package zio.aws.eventbridge
import zio.aws.eventbridge.model.CreateEventBusResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.eventbridge.{
  EventBridgeAsyncClientBuilder,
  EventBridgeAsyncClient
}
import zio.aws.eventbridge.model.primitives.RuleName
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.eventbridge.model.{
  DescribeReplayRequest,
  CreateEndpointRequest,
  TestEventPatternRequest,
  DeleteEventBusRequest,
  PutTargetsRequest,
  DeleteEndpointRequest,
  EnableRuleRequest,
  DeactivateEventSourceRequest,
  RemoveTargetsRequest,
  ListTargetsByRuleRequest,
  CreateConnectionRequest,
  DescribePartnerEventSourceRequest,
  ListEndpointsRequest,
  ListPartnerEventSourceAccountsRequest,
  ListRulesRequest,
  CreatePartnerEventSourceRequest,
  ListArchivesRequest,
  PutPermissionRequest,
  DescribeRuleRequest,
  CreateArchiveRequest,
  UpdateEndpointRequest,
  ListTagsForResourceRequest,
  DeauthorizeConnectionRequest,
  DeleteApiDestinationRequest,
  CreateEventBusRequest,
  PutRuleRequest,
  ListEventBusesRequest,
  DeletePartnerEventSourceRequest,
  DeleteConnectionRequest,
  DescribeEventSourceRequest,
  DeleteArchiveRequest,
  ListEventSourcesRequest,
  PutPartnerEventsRequest,
  UpdateArchiveRequest,
  ActivateEventSourceRequest,
  DeleteRuleRequest,
  DescribeArchiveRequest,
  CreateApiDestinationRequest,
  ListReplaysRequest,
  UpdateConnectionRequest,
  DescribeEventBusRequest,
  UpdateApiDestinationRequest,
  UntagResourceRequest,
  PutEventsRequest,
  DescribeEndpointRequest,
  ListConnectionsRequest,
  ListRuleNamesByTargetRequest,
  DescribeApiDestinationRequest,
  RemovePermissionRequest,
  CancelReplayRequest,
  ListPartnerEventSourcesRequest,
  DescribeConnectionRequest,
  TagResourceRequest,
  StartReplayRequest,
  DisableRuleRequest,
  ListApiDestinationsRequest
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import software.amazon.awssdk.services.eventbridge.model.{
  StartReplayResponse,
  ListEventBusesResponse,
  PartnerEventSourceAccount,
  DeletePartnerEventSourceResponse,
  ListConnectionsResponse,
  DeleteEndpointResponse,
  DeleteConnectionResponse,
  PutPermissionResponse,
  ListPartnerEventSourcesResponse,
  DisableRuleResponse,
  DeleteArchiveResponse,
  UpdateEndpointResponse,
  CreateArchiveResponse,
  ListEndpointsResponse,
  ListTargetsByRuleResponse,
  ListRulesResponse,
  ListEventSourcesResponse,
  Archive,
  DeauthorizeConnectionResponse,
  ListArchivesResponse,
  RemovePermissionResponse,
  CreatePartnerEventSourceResponse,
  EnableRuleResponse,
  DescribeApiDestinationResponse,
  CreateConnectionResponse,
  PutTargetsResponse,
  ListRuleNamesByTargetResponse,
  DeleteApiDestinationResponse,
  DeactivateEventSourceResponse,
  PutPartnerEventsResponse,
  UpdateApiDestinationResponse,
  Replay,
  DescribeEndpointResponse,
  EventBus,
  ListTagsForResourceResponse,
  ListPartnerEventSourceAccountsResponse,
  UntagResourceResponse,
  DescribePartnerEventSourceResponse,
  PartnerEventSource,
  DeleteEventBusResponse,
  DescribeRuleResponse,
  Connection,
  DescribeEventSourceResponse,
  CreateEventBusResponse,
  Rule,
  CancelReplayResponse,
  ApiDestination,
  PutEventsResponse,
  CreateEndpointResponse,
  DescribeConnectionResponse,
  TestEventPatternResponse,
  PutRuleResponse,
  ActivateEventSourceResponse,
  Endpoint,
  CreateApiDestinationResponse,
  DescribeArchiveResponse,
  UpdateArchiveResponse,
  ListReplaysResponse,
  TagResourceResponse,
  DescribeReplayResponse,
  RemoveTargetsResponse,
  EventSource,
  Target,
  ListApiDestinationsResponse,
  DeleteRuleResponse,
  UpdateConnectionResponse,
  DescribeEventBusResponse
}
import scala.jdk.CollectionConverters.*
trait EventBridge extends AspectSupport[EventBridge] {
  val api: EventBridgeAsyncClient
  def cancelReplay(
      request: CancelReplayRequest
  ): IO[AwsError, zio.aws.eventbridge.model.CancelReplayResponse.ReadOnly]
  def createArchive(
      request: CreateArchiveRequest
  ): IO[AwsError, zio.aws.eventbridge.model.CreateArchiveResponse.ReadOnly]
  def putPermission(request: PutPermissionRequest): IO[AwsError, Unit]
  def deleteEventBus(request: DeleteEventBusRequest): IO[AwsError, Unit]
  def activateEventSource(
      request: ActivateEventSourceRequest
  ): IO[AwsError, Unit]
  def listArchives(
      request: ListArchivesRequest
  ): ZStream[Any, AwsError, zio.aws.eventbridge.model.Archive.ReadOnly]
  def listArchivesPaginated(
      request: ListArchivesRequest
  ): IO[AwsError, zio.aws.eventbridge.model.ListArchivesResponse.ReadOnly]
  def createPartnerEventSource(request: CreatePartnerEventSourceRequest): IO[
    AwsError,
    zio.aws.eventbridge.model.CreatePartnerEventSourceResponse.ReadOnly
  ]
  def createConnection(
      request: CreateConnectionRequest
  ): IO[AwsError, zio.aws.eventbridge.model.CreateConnectionResponse.ReadOnly]
  def deleteApiDestination(request: DeleteApiDestinationRequest): IO[
    AwsError,
    zio.aws.eventbridge.model.DeleteApiDestinationResponse.ReadOnly
  ]
  def describeConnection(
      request: DescribeConnectionRequest
  ): IO[AwsError, zio.aws.eventbridge.model.DescribeConnectionResponse.ReadOnly]
  def testEventPattern(
      request: TestEventPatternRequest
  ): IO[AwsError, zio.aws.eventbridge.model.TestEventPatternResponse.ReadOnly]
  def updateConnection(
      request: UpdateConnectionRequest
  ): IO[AwsError, zio.aws.eventbridge.model.UpdateConnectionResponse.ReadOnly]
  def putTargets(
      request: PutTargetsRequest
  ): IO[AwsError, zio.aws.eventbridge.model.PutTargetsResponse.ReadOnly]
  def createEventBus(request: CreateEventBusRequest): IO[AwsError, ReadOnly]
  def disableRule(request: DisableRuleRequest): IO[AwsError, Unit]
  def listPartnerEventSources(request: ListPartnerEventSourcesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.eventbridge.model.PartnerEventSource.ReadOnly
  ]
  def listPartnerEventSourcesPaginated(
      request: ListPartnerEventSourcesRequest
  ): IO[
    AwsError,
    zio.aws.eventbridge.model.ListPartnerEventSourcesResponse.ReadOnly
  ]
  def putEvents(
      request: PutEventsRequest
  ): IO[AwsError, zio.aws.eventbridge.model.PutEventsResponse.ReadOnly]
  def deleteRule(request: DeleteRuleRequest): IO[AwsError, Unit]
  def deleteArchive(
      request: DeleteArchiveRequest
  ): IO[AwsError, zio.aws.eventbridge.model.DeleteArchiveResponse.ReadOnly]
  def deleteEndpoint(
      request: DeleteEndpointRequest
  ): IO[AwsError, zio.aws.eventbridge.model.DeleteEndpointResponse.ReadOnly]
  def listConnections(
      request: ListConnectionsRequest
  ): ZStream[Any, AwsError, zio.aws.eventbridge.model.Connection.ReadOnly]
  def listConnectionsPaginated(
      request: ListConnectionsRequest
  ): IO[AwsError, zio.aws.eventbridge.model.ListConnectionsResponse.ReadOnly]
  def describePartnerEventSource(
      request: DescribePartnerEventSourceRequest
  ): IO[
    AwsError,
    zio.aws.eventbridge.model.DescribePartnerEventSourceResponse.ReadOnly
  ]
  def listEventBuses(
      request: ListEventBusesRequest
  ): ZStream[Any, AwsError, zio.aws.eventbridge.model.EventBus.ReadOnly]
  def listEventBusesPaginated(
      request: ListEventBusesRequest
  ): IO[AwsError, zio.aws.eventbridge.model.ListEventBusesResponse.ReadOnly]
  def updateArchive(
      request: UpdateArchiveRequest
  ): IO[AwsError, zio.aws.eventbridge.model.UpdateArchiveResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.eventbridge.model.UntagResourceResponse.ReadOnly]
  def describeEndpoint(
      request: DescribeEndpointRequest
  ): IO[AwsError, zio.aws.eventbridge.model.DescribeEndpointResponse.ReadOnly]
  def putRule(
      request: PutRuleRequest
  ): IO[AwsError, zio.aws.eventbridge.model.PutRuleResponse.ReadOnly]
  def describeRule(
      request: DescribeRuleRequest
  ): IO[AwsError, zio.aws.eventbridge.model.DescribeRuleResponse.ReadOnly]
  def listEventSources(
      request: ListEventSourcesRequest
  ): ZStream[Any, AwsError, zio.aws.eventbridge.model.EventSource.ReadOnly]
  def listEventSourcesPaginated(
      request: ListEventSourcesRequest
  ): IO[AwsError, zio.aws.eventbridge.model.ListEventSourcesResponse.ReadOnly]
  def listApiDestinations(
      request: ListApiDestinationsRequest
  ): ZStream[Any, AwsError, zio.aws.eventbridge.model.ApiDestination.ReadOnly]
  def listApiDestinationsPaginated(request: ListApiDestinationsRequest): IO[
    AwsError,
    zio.aws.eventbridge.model.ListApiDestinationsResponse.ReadOnly
  ]
  def removePermission(request: RemovePermissionRequest): IO[AwsError, Unit]
  def deletePartnerEventSource(
      request: DeletePartnerEventSourceRequest
  ): IO[AwsError, Unit]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.eventbridge.model.ListTagsForResourceResponse.ReadOnly
  ]
  def describeApiDestination(request: DescribeApiDestinationRequest): IO[
    AwsError,
    zio.aws.eventbridge.model.DescribeApiDestinationResponse.ReadOnly
  ]
  def deleteConnection(
      request: DeleteConnectionRequest
  ): IO[AwsError, zio.aws.eventbridge.model.DeleteConnectionResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.eventbridge.model.TagResourceResponse.ReadOnly]
  def createEndpoint(
      request: CreateEndpointRequest
  ): IO[AwsError, zio.aws.eventbridge.model.CreateEndpointResponse.ReadOnly]
  def listRules(
      request: ListRulesRequest
  ): ZStream[Any, AwsError, zio.aws.eventbridge.model.Rule.ReadOnly]
  def listRulesPaginated(
      request: ListRulesRequest
  ): IO[AwsError, zio.aws.eventbridge.model.ListRulesResponse.ReadOnly]
  def updateEndpoint(
      request: UpdateEndpointRequest
  ): IO[AwsError, zio.aws.eventbridge.model.UpdateEndpointResponse.ReadOnly]
  def listEndpoints(
      request: ListEndpointsRequest
  ): ZStream[Any, AwsError, zio.aws.eventbridge.model.Endpoint.ReadOnly]
  def listEndpointsPaginated(
      request: ListEndpointsRequest
  ): IO[AwsError, zio.aws.eventbridge.model.ListEndpointsResponse.ReadOnly]
  def createApiDestination(request: CreateApiDestinationRequest): IO[
    AwsError,
    zio.aws.eventbridge.model.CreateApiDestinationResponse.ReadOnly
  ]
  def deauthorizeConnection(request: DeauthorizeConnectionRequest): IO[
    AwsError,
    zio.aws.eventbridge.model.DeauthorizeConnectionResponse.ReadOnly
  ]
  def updateApiDestination(request: UpdateApiDestinationRequest): IO[
    AwsError,
    zio.aws.eventbridge.model.UpdateApiDestinationResponse.ReadOnly
  ]
  def describeReplay(
      request: DescribeReplayRequest
  ): IO[AwsError, zio.aws.eventbridge.model.DescribeReplayResponse.ReadOnly]
  def listRuleNamesByTarget(
      request: ListRuleNamesByTargetRequest
  ): ZStream[Any, AwsError, RuleName]
  def listRuleNamesByTargetPaginated(request: ListRuleNamesByTargetRequest): IO[
    AwsError,
    zio.aws.eventbridge.model.ListRuleNamesByTargetResponse.ReadOnly
  ]
  def listReplays(
      request: ListReplaysRequest
  ): ZStream[Any, AwsError, zio.aws.eventbridge.model.Replay.ReadOnly]
  def listReplaysPaginated(
      request: ListReplaysRequest
  ): IO[AwsError, zio.aws.eventbridge.model.ListReplaysResponse.ReadOnly]
  def enableRule(request: EnableRuleRequest): IO[AwsError, Unit]
  def describeEventBus(
      request: DescribeEventBusRequest
  ): IO[AwsError, zio.aws.eventbridge.model.DescribeEventBusResponse.ReadOnly]
  def startReplay(
      request: StartReplayRequest
  ): IO[AwsError, zio.aws.eventbridge.model.StartReplayResponse.ReadOnly]
  def describeEventSource(request: DescribeEventSourceRequest): IO[
    AwsError,
    zio.aws.eventbridge.model.DescribeEventSourceResponse.ReadOnly
  ]
  def putPartnerEvents(
      request: PutPartnerEventsRequest
  ): IO[AwsError, zio.aws.eventbridge.model.PutPartnerEventsResponse.ReadOnly]
  def removeTargets(
      request: RemoveTargetsRequest
  ): IO[AwsError, zio.aws.eventbridge.model.RemoveTargetsResponse.ReadOnly]
  def deactivateEventSource(
      request: DeactivateEventSourceRequest
  ): IO[AwsError, Unit]
  def listPartnerEventSourceAccounts(
      request: ListPartnerEventSourceAccountsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.eventbridge.model.PartnerEventSourceAccount.ReadOnly
  ]
  def listPartnerEventSourceAccountsPaginated(
      request: ListPartnerEventSourceAccountsRequest
  ): IO[
    AwsError,
    zio.aws.eventbridge.model.ListPartnerEventSourceAccountsResponse.ReadOnly
  ]
  def describeArchive(
      request: DescribeArchiveRequest
  ): IO[AwsError, zio.aws.eventbridge.model.DescribeArchiveResponse.ReadOnly]
  def listTargetsByRule(
      request: ListTargetsByRuleRequest
  ): ZStream[Any, AwsError, zio.aws.eventbridge.model.Target.ReadOnly]
  def listTargetsByRulePaginated(
      request: ListTargetsByRuleRequest
  ): IO[AwsError, zio.aws.eventbridge.model.ListTargetsByRuleResponse.ReadOnly]
}
object EventBridge {
  val live: ZLayer[AwsConfig, java.lang.Throwable, EventBridge] = customized(
    identity
  )
  def customized(
      customization: EventBridgeAsyncClientBuilder => EventBridgeAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, EventBridge] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: EventBridgeAsyncClientBuilder => EventBridgeAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, EventBridge] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = EventBridgeAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[EventBridgeAsyncClient, EventBridgeAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      EventBridgeAsyncClient,
      EventBridgeAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new EventBridgeImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class EventBridgeImpl[R](
      override val api: EventBridgeAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends EventBridge
      with AwsServiceBase[R] {
    override val serviceName: String = "EventBridge"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): EventBridgeImpl[R1] = new EventBridgeImpl(api, newAspect, r)
    def cancelReplay(
        request: CancelReplayRequest
    ): IO[AwsError, zio.aws.eventbridge.model.CancelReplayResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.CancelReplayRequest,
        CancelReplayResponse
      ]("cancelReplay", api.cancelReplay)(request.buildAwsValue())
        .map(zio.aws.eventbridge.model.CancelReplayResponse.wrap)
        .provideEnvironment(r)
    def createArchive(
        request: CreateArchiveRequest
    ): IO[AwsError, zio.aws.eventbridge.model.CreateArchiveResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.CreateArchiveRequest,
        CreateArchiveResponse
      ]("createArchive", api.createArchive)(request.buildAwsValue())
        .map(zio.aws.eventbridge.model.CreateArchiveResponse.wrap)
        .provideEnvironment(r)
    def putPermission(request: PutPermissionRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.PutPermissionRequest,
        PutPermissionResponse
      ]("putPermission", api.putPermission)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteEventBus(request: DeleteEventBusRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.DeleteEventBusRequest,
        DeleteEventBusResponse
      ]("deleteEventBus", api.deleteEventBus)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def activateEventSource(
        request: ActivateEventSourceRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.ActivateEventSourceRequest,
      ActivateEventSourceResponse
    ]("activateEventSource", api.activateEventSource)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listArchives(
        request: ListArchivesRequest
    ): ZStream[Any, AwsError, zio.aws.eventbridge.model.Archive.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.eventbridge.model.ListArchivesRequest,
        ListArchivesResponse,
        Archive
      ](
        "listArchives",
        api.listArchives,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.archives().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.eventbridge.model.Archive.wrap(item))
        .provideEnvironment(r)
    def listArchivesPaginated(
        request: ListArchivesRequest
    ): IO[AwsError, zio.aws.eventbridge.model.ListArchivesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.ListArchivesRequest,
        ListArchivesResponse
      ]("listArchives", api.listArchives)(request.buildAwsValue())
        .map(zio.aws.eventbridge.model.ListArchivesResponse.wrap)
        .provideEnvironment(r)
    def createPartnerEventSource(request: CreatePartnerEventSourceRequest): IO[
      AwsError,
      zio.aws.eventbridge.model.CreatePartnerEventSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.CreatePartnerEventSourceRequest,
      CreatePartnerEventSourceResponse
    ]("createPartnerEventSource", api.createPartnerEventSource)(
      request.buildAwsValue()
    ).map(zio.aws.eventbridge.model.CreatePartnerEventSourceResponse.wrap)
      .provideEnvironment(r)
    def createConnection(request: CreateConnectionRequest): IO[
      AwsError,
      zio.aws.eventbridge.model.CreateConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.CreateConnectionRequest,
      CreateConnectionResponse
    ]("createConnection", api.createConnection)(request.buildAwsValue())
      .map(zio.aws.eventbridge.model.CreateConnectionResponse.wrap)
      .provideEnvironment(r)
    def deleteApiDestination(request: DeleteApiDestinationRequest): IO[
      AwsError,
      zio.aws.eventbridge.model.DeleteApiDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.DeleteApiDestinationRequest,
      DeleteApiDestinationResponse
    ]("deleteApiDestination", api.deleteApiDestination)(request.buildAwsValue())
      .map(zio.aws.eventbridge.model.DeleteApiDestinationResponse.wrap)
      .provideEnvironment(r)
    def describeConnection(request: DescribeConnectionRequest): IO[
      AwsError,
      zio.aws.eventbridge.model.DescribeConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.DescribeConnectionRequest,
      DescribeConnectionResponse
    ]("describeConnection", api.describeConnection)(request.buildAwsValue())
      .map(zio.aws.eventbridge.model.DescribeConnectionResponse.wrap)
      .provideEnvironment(r)
    def testEventPattern(request: TestEventPatternRequest): IO[
      AwsError,
      zio.aws.eventbridge.model.TestEventPatternResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.TestEventPatternRequest,
      TestEventPatternResponse
    ]("testEventPattern", api.testEventPattern)(request.buildAwsValue())
      .map(zio.aws.eventbridge.model.TestEventPatternResponse.wrap)
      .provideEnvironment(r)
    def updateConnection(request: UpdateConnectionRequest): IO[
      AwsError,
      zio.aws.eventbridge.model.UpdateConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.UpdateConnectionRequest,
      UpdateConnectionResponse
    ]("updateConnection", api.updateConnection)(request.buildAwsValue())
      .map(zio.aws.eventbridge.model.UpdateConnectionResponse.wrap)
      .provideEnvironment(r)
    def putTargets(
        request: PutTargetsRequest
    ): IO[AwsError, zio.aws.eventbridge.model.PutTargetsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.PutTargetsRequest,
        PutTargetsResponse
      ]("putTargets", api.putTargets)(request.buildAwsValue())
        .map(zio.aws.eventbridge.model.PutTargetsResponse.wrap)
        .provideEnvironment(r)
    def createEventBus(request: CreateEventBusRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.CreateEventBusRequest,
        CreateEventBusResponse
      ]("createEventBus", api.createEventBus)(request.buildAwsValue())
        .map(zio.aws.eventbridge.model.CreateEventBusResponse.wrap)
        .provideEnvironment(r)
    def disableRule(request: DisableRuleRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.DisableRuleRequest,
        DisableRuleResponse
      ]("disableRule", api.disableRule)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listPartnerEventSources(
        request: ListPartnerEventSourcesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.eventbridge.model.PartnerEventSource.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourcesRequest,
      ListPartnerEventSourcesResponse,
      PartnerEventSource
    ](
      "listPartnerEventSources",
      api.listPartnerEventSources,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.partnerEventSources().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.eventbridge.model.PartnerEventSource.wrap(item))
      .provideEnvironment(r)
    def listPartnerEventSourcesPaginated(
        request: ListPartnerEventSourcesRequest
    ): IO[
      AwsError,
      zio.aws.eventbridge.model.ListPartnerEventSourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourcesRequest,
      ListPartnerEventSourcesResponse
    ]("listPartnerEventSources", api.listPartnerEventSources)(
      request.buildAwsValue()
    ).map(zio.aws.eventbridge.model.ListPartnerEventSourcesResponse.wrap)
      .provideEnvironment(r)
    def putEvents(
        request: PutEventsRequest
    ): IO[AwsError, zio.aws.eventbridge.model.PutEventsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.PutEventsRequest,
        PutEventsResponse
      ]("putEvents", api.putEvents)(request.buildAwsValue())
        .map(zio.aws.eventbridge.model.PutEventsResponse.wrap)
        .provideEnvironment(r)
    def deleteRule(request: DeleteRuleRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.DeleteRuleRequest,
        DeleteRuleResponse
      ]("deleteRule", api.deleteRule)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteArchive(
        request: DeleteArchiveRequest
    ): IO[AwsError, zio.aws.eventbridge.model.DeleteArchiveResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.DeleteArchiveRequest,
        DeleteArchiveResponse
      ]("deleteArchive", api.deleteArchive)(request.buildAwsValue())
        .map(zio.aws.eventbridge.model.DeleteArchiveResponse.wrap)
        .provideEnvironment(r)
    def deleteEndpoint(
        request: DeleteEndpointRequest
    ): IO[AwsError, zio.aws.eventbridge.model.DeleteEndpointResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.DeleteEndpointRequest,
        DeleteEndpointResponse
      ]("deleteEndpoint", api.deleteEndpoint)(request.buildAwsValue())
        .map(zio.aws.eventbridge.model.DeleteEndpointResponse.wrap)
        .provideEnvironment(r)
    def listConnections(request: ListConnectionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.eventbridge.model.Connection.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.eventbridge.model.ListConnectionsRequest,
      ListConnectionsResponse,
      Connection
    ](
      "listConnections",
      api.listConnections,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.connections().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.eventbridge.model.Connection.wrap(item))
      .provideEnvironment(r)
    def listConnectionsPaginated(request: ListConnectionsRequest): IO[
      AwsError,
      zio.aws.eventbridge.model.ListConnectionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.ListConnectionsRequest,
      ListConnectionsResponse
    ]("listConnections", api.listConnections)(request.buildAwsValue())
      .map(zio.aws.eventbridge.model.ListConnectionsResponse.wrap)
      .provideEnvironment(r)
    def describePartnerEventSource(
        request: DescribePartnerEventSourceRequest
    ): IO[
      AwsError,
      zio.aws.eventbridge.model.DescribePartnerEventSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.DescribePartnerEventSourceRequest,
      DescribePartnerEventSourceResponse
    ]("describePartnerEventSource", api.describePartnerEventSource)(
      request.buildAwsValue()
    ).map(zio.aws.eventbridge.model.DescribePartnerEventSourceResponse.wrap)
      .provideEnvironment(r)
    def listEventBuses(
        request: ListEventBusesRequest
    ): ZStream[Any, AwsError, zio.aws.eventbridge.model.EventBus.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.eventbridge.model.ListEventBusesRequest,
        ListEventBusesResponse,
        EventBus
      ](
        "listEventBuses",
        api.listEventBuses,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.eventBuses().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.eventbridge.model.EventBus.wrap(item))
        .provideEnvironment(r)
    def listEventBusesPaginated(
        request: ListEventBusesRequest
    ): IO[AwsError, zio.aws.eventbridge.model.ListEventBusesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.ListEventBusesRequest,
        ListEventBusesResponse
      ]("listEventBuses", api.listEventBuses)(request.buildAwsValue())
        .map(zio.aws.eventbridge.model.ListEventBusesResponse.wrap)
        .provideEnvironment(r)
    def updateArchive(
        request: UpdateArchiveRequest
    ): IO[AwsError, zio.aws.eventbridge.model.UpdateArchiveResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.UpdateArchiveRequest,
        UpdateArchiveResponse
      ]("updateArchive", api.updateArchive)(request.buildAwsValue())
        .map(zio.aws.eventbridge.model.UpdateArchiveResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.eventbridge.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.eventbridge.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def describeEndpoint(request: DescribeEndpointRequest): IO[
      AwsError,
      zio.aws.eventbridge.model.DescribeEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.DescribeEndpointRequest,
      DescribeEndpointResponse
    ]("describeEndpoint", api.describeEndpoint)(request.buildAwsValue())
      .map(zio.aws.eventbridge.model.DescribeEndpointResponse.wrap)
      .provideEnvironment(r)
    def putRule(
        request: PutRuleRequest
    ): IO[AwsError, zio.aws.eventbridge.model.PutRuleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.PutRuleRequest,
        PutRuleResponse
      ]("putRule", api.putRule)(request.buildAwsValue())
        .map(zio.aws.eventbridge.model.PutRuleResponse.wrap)
        .provideEnvironment(r)
    def describeRule(
        request: DescribeRuleRequest
    ): IO[AwsError, zio.aws.eventbridge.model.DescribeRuleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.DescribeRuleRequest,
        DescribeRuleResponse
      ]("describeRule", api.describeRule)(request.buildAwsValue())
        .map(zio.aws.eventbridge.model.DescribeRuleResponse.wrap)
        .provideEnvironment(r)
    def listEventSources(request: ListEventSourcesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.eventbridge.model.EventSource.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.eventbridge.model.ListEventSourcesRequest,
      ListEventSourcesResponse,
      EventSource
    ](
      "listEventSources",
      api.listEventSources,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.eventSources().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.eventbridge.model.EventSource.wrap(item))
      .provideEnvironment(r)
    def listEventSourcesPaginated(request: ListEventSourcesRequest): IO[
      AwsError,
      zio.aws.eventbridge.model.ListEventSourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.ListEventSourcesRequest,
      ListEventSourcesResponse
    ]("listEventSources", api.listEventSources)(request.buildAwsValue())
      .map(zio.aws.eventbridge.model.ListEventSourcesResponse.wrap)
      .provideEnvironment(r)
    def listApiDestinations(request: ListApiDestinationsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.eventbridge.model.ApiDestination.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.eventbridge.model.ListApiDestinationsRequest,
      ListApiDestinationsResponse,
      ApiDestination
    ](
      "listApiDestinations",
      api.listApiDestinations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.apiDestinations().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.eventbridge.model.ApiDestination.wrap(item))
      .provideEnvironment(r)
    def listApiDestinationsPaginated(request: ListApiDestinationsRequest): IO[
      AwsError,
      zio.aws.eventbridge.model.ListApiDestinationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.ListApiDestinationsRequest,
      ListApiDestinationsResponse
    ]("listApiDestinations", api.listApiDestinations)(request.buildAwsValue())
      .map(zio.aws.eventbridge.model.ListApiDestinationsResponse.wrap)
      .provideEnvironment(r)
    def removePermission(request: RemovePermissionRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.RemovePermissionRequest,
        RemovePermissionResponse
      ]("removePermission", api.removePermission)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deletePartnerEventSource(
        request: DeletePartnerEventSourceRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.DeletePartnerEventSourceRequest,
      DeletePartnerEventSourceResponse
    ]("deletePartnerEventSource", api.deletePartnerEventSource)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.eventbridge.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.eventbridge.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def describeApiDestination(request: DescribeApiDestinationRequest): IO[
      AwsError,
      zio.aws.eventbridge.model.DescribeApiDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.DescribeApiDestinationRequest,
      DescribeApiDestinationResponse
    ]("describeApiDestination", api.describeApiDestination)(
      request.buildAwsValue()
    ).map(zio.aws.eventbridge.model.DescribeApiDestinationResponse.wrap)
      .provideEnvironment(r)
    def deleteConnection(request: DeleteConnectionRequest): IO[
      AwsError,
      zio.aws.eventbridge.model.DeleteConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.DeleteConnectionRequest,
      DeleteConnectionResponse
    ]("deleteConnection", api.deleteConnection)(request.buildAwsValue())
      .map(zio.aws.eventbridge.model.DeleteConnectionResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.eventbridge.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.eventbridge.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def createEndpoint(
        request: CreateEndpointRequest
    ): IO[AwsError, zio.aws.eventbridge.model.CreateEndpointResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.CreateEndpointRequest,
        CreateEndpointResponse
      ]("createEndpoint", api.createEndpoint)(request.buildAwsValue())
        .map(zio.aws.eventbridge.model.CreateEndpointResponse.wrap)
        .provideEnvironment(r)
    def listRules(
        request: ListRulesRequest
    ): ZStream[Any, AwsError, zio.aws.eventbridge.model.Rule.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.eventbridge.model.ListRulesRequest,
        ListRulesResponse,
        Rule
      ](
        "listRules",
        api.listRules,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.rules().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.eventbridge.model.Rule.wrap(item))
        .provideEnvironment(r)
    def listRulesPaginated(
        request: ListRulesRequest
    ): IO[AwsError, zio.aws.eventbridge.model.ListRulesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.ListRulesRequest,
        ListRulesResponse
      ]("listRules", api.listRules)(request.buildAwsValue())
        .map(zio.aws.eventbridge.model.ListRulesResponse.wrap)
        .provideEnvironment(r)
    def updateEndpoint(
        request: UpdateEndpointRequest
    ): IO[AwsError, zio.aws.eventbridge.model.UpdateEndpointResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.UpdateEndpointRequest,
        UpdateEndpointResponse
      ]("updateEndpoint", api.updateEndpoint)(request.buildAwsValue())
        .map(zio.aws.eventbridge.model.UpdateEndpointResponse.wrap)
        .provideEnvironment(r)
    def listEndpoints(
        request: ListEndpointsRequest
    ): ZStream[Any, AwsError, zio.aws.eventbridge.model.Endpoint.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.eventbridge.model.ListEndpointsRequest,
        ListEndpointsResponse,
        Endpoint
      ](
        "listEndpoints",
        api.listEndpoints,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.endpoints().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.eventbridge.model.Endpoint.wrap(item))
        .provideEnvironment(r)
    def listEndpointsPaginated(
        request: ListEndpointsRequest
    ): IO[AwsError, zio.aws.eventbridge.model.ListEndpointsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.ListEndpointsRequest,
        ListEndpointsResponse
      ]("listEndpoints", api.listEndpoints)(request.buildAwsValue())
        .map(zio.aws.eventbridge.model.ListEndpointsResponse.wrap)
        .provideEnvironment(r)
    def createApiDestination(request: CreateApiDestinationRequest): IO[
      AwsError,
      zio.aws.eventbridge.model.CreateApiDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.CreateApiDestinationRequest,
      CreateApiDestinationResponse
    ]("createApiDestination", api.createApiDestination)(request.buildAwsValue())
      .map(zio.aws.eventbridge.model.CreateApiDestinationResponse.wrap)
      .provideEnvironment(r)
    def deauthorizeConnection(request: DeauthorizeConnectionRequest): IO[
      AwsError,
      zio.aws.eventbridge.model.DeauthorizeConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.DeauthorizeConnectionRequest,
      DeauthorizeConnectionResponse
    ]("deauthorizeConnection", api.deauthorizeConnection)(
      request.buildAwsValue()
    ).map(zio.aws.eventbridge.model.DeauthorizeConnectionResponse.wrap)
      .provideEnvironment(r)
    def updateApiDestination(request: UpdateApiDestinationRequest): IO[
      AwsError,
      zio.aws.eventbridge.model.UpdateApiDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.UpdateApiDestinationRequest,
      UpdateApiDestinationResponse
    ]("updateApiDestination", api.updateApiDestination)(request.buildAwsValue())
      .map(zio.aws.eventbridge.model.UpdateApiDestinationResponse.wrap)
      .provideEnvironment(r)
    def describeReplay(
        request: DescribeReplayRequest
    ): IO[AwsError, zio.aws.eventbridge.model.DescribeReplayResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.DescribeReplayRequest,
        DescribeReplayResponse
      ]("describeReplay", api.describeReplay)(request.buildAwsValue())
        .map(zio.aws.eventbridge.model.DescribeReplayResponse.wrap)
        .provideEnvironment(r)
    def listRuleNamesByTarget(
        request: ListRuleNamesByTargetRequest
    ): ZStream[Any, AwsError, RuleName] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.eventbridge.model.ListRuleNamesByTargetRequest,
      ListRuleNamesByTargetResponse,
      java.lang.String
    ](
      "listRuleNamesByTarget",
      api.listRuleNamesByTarget,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.ruleNames().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.eventbridge.model.primitives.RuleName(item))
      .provideEnvironment(r)
    def listRuleNamesByTargetPaginated(
        request: ListRuleNamesByTargetRequest
    ): IO[
      AwsError,
      zio.aws.eventbridge.model.ListRuleNamesByTargetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.ListRuleNamesByTargetRequest,
      ListRuleNamesByTargetResponse
    ]("listRuleNamesByTarget", api.listRuleNamesByTarget)(
      request.buildAwsValue()
    ).map(zio.aws.eventbridge.model.ListRuleNamesByTargetResponse.wrap)
      .provideEnvironment(r)
    def listReplays(
        request: ListReplaysRequest
    ): ZStream[Any, AwsError, zio.aws.eventbridge.model.Replay.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.eventbridge.model.ListReplaysRequest,
        ListReplaysResponse,
        Replay
      ](
        "listReplays",
        api.listReplays,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.replays().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.eventbridge.model.Replay.wrap(item))
        .provideEnvironment(r)
    def listReplaysPaginated(
        request: ListReplaysRequest
    ): IO[AwsError, zio.aws.eventbridge.model.ListReplaysResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.ListReplaysRequest,
        ListReplaysResponse
      ]("listReplays", api.listReplays)(request.buildAwsValue())
        .map(zio.aws.eventbridge.model.ListReplaysResponse.wrap)
        .provideEnvironment(r)
    def enableRule(request: EnableRuleRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.EnableRuleRequest,
        EnableRuleResponse
      ]("enableRule", api.enableRule)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def describeEventBus(request: DescribeEventBusRequest): IO[
      AwsError,
      zio.aws.eventbridge.model.DescribeEventBusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.DescribeEventBusRequest,
      DescribeEventBusResponse
    ]("describeEventBus", api.describeEventBus)(request.buildAwsValue())
      .map(zio.aws.eventbridge.model.DescribeEventBusResponse.wrap)
      .provideEnvironment(r)
    def startReplay(
        request: StartReplayRequest
    ): IO[AwsError, zio.aws.eventbridge.model.StartReplayResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.StartReplayRequest,
        StartReplayResponse
      ]("startReplay", api.startReplay)(request.buildAwsValue())
        .map(zio.aws.eventbridge.model.StartReplayResponse.wrap)
        .provideEnvironment(r)
    def describeEventSource(request: DescribeEventSourceRequest): IO[
      AwsError,
      zio.aws.eventbridge.model.DescribeEventSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.DescribeEventSourceRequest,
      DescribeEventSourceResponse
    ]("describeEventSource", api.describeEventSource)(request.buildAwsValue())
      .map(zio.aws.eventbridge.model.DescribeEventSourceResponse.wrap)
      .provideEnvironment(r)
    def putPartnerEvents(request: PutPartnerEventsRequest): IO[
      AwsError,
      zio.aws.eventbridge.model.PutPartnerEventsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsRequest,
      PutPartnerEventsResponse
    ]("putPartnerEvents", api.putPartnerEvents)(request.buildAwsValue())
      .map(zio.aws.eventbridge.model.PutPartnerEventsResponse.wrap)
      .provideEnvironment(r)
    def removeTargets(
        request: RemoveTargetsRequest
    ): IO[AwsError, zio.aws.eventbridge.model.RemoveTargetsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eventbridge.model.RemoveTargetsRequest,
        RemoveTargetsResponse
      ]("removeTargets", api.removeTargets)(request.buildAwsValue())
        .map(zio.aws.eventbridge.model.RemoveTargetsResponse.wrap)
        .provideEnvironment(r)
    def deactivateEventSource(
        request: DeactivateEventSourceRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.DeactivateEventSourceRequest,
      DeactivateEventSourceResponse
    ]("deactivateEventSource", api.deactivateEventSource)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listPartnerEventSourceAccounts(
        request: ListPartnerEventSourceAccountsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.eventbridge.model.PartnerEventSourceAccount.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourceAccountsRequest,
      ListPartnerEventSourceAccountsResponse,
      PartnerEventSourceAccount
    ](
      "listPartnerEventSourceAccounts",
      api.listPartnerEventSourceAccounts,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.partnerEventSourceAccounts().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.eventbridge.model.PartnerEventSourceAccount.wrap(item)
      )
      .provideEnvironment(r)
    def listPartnerEventSourceAccountsPaginated(
        request: ListPartnerEventSourceAccountsRequest
    ): IO[
      AwsError,
      zio.aws.eventbridge.model.ListPartnerEventSourceAccountsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourceAccountsRequest,
      ListPartnerEventSourceAccountsResponse
    ]("listPartnerEventSourceAccounts", api.listPartnerEventSourceAccounts)(
      request.buildAwsValue()
    ).map(zio.aws.eventbridge.model.ListPartnerEventSourceAccountsResponse.wrap)
      .provideEnvironment(r)
    def describeArchive(request: DescribeArchiveRequest): IO[
      AwsError,
      zio.aws.eventbridge.model.DescribeArchiveResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.DescribeArchiveRequest,
      DescribeArchiveResponse
    ]("describeArchive", api.describeArchive)(request.buildAwsValue())
      .map(zio.aws.eventbridge.model.DescribeArchiveResponse.wrap)
      .provideEnvironment(r)
    def listTargetsByRule(request: ListTargetsByRuleRequest): ZStream[
      Any,
      AwsError,
      zio.aws.eventbridge.model.Target.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.eventbridge.model.ListTargetsByRuleRequest,
      ListTargetsByRuleResponse,
      Target
    ](
      "listTargetsByRule",
      api.listTargetsByRule,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.targets().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.eventbridge.model.Target.wrap(item))
      .provideEnvironment(r)
    def listTargetsByRulePaginated(request: ListTargetsByRuleRequest): IO[
      AwsError,
      zio.aws.eventbridge.model.ListTargetsByRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eventbridge.model.ListTargetsByRuleRequest,
      ListTargetsByRuleResponse
    ]("listTargetsByRule", api.listTargetsByRule)(request.buildAwsValue())
      .map(zio.aws.eventbridge.model.ListTargetsByRuleResponse.wrap)
      .provideEnvironment(r)
  }
  def cancelReplay(request: CancelReplayRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.CancelReplayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelReplay(request))
  def createArchive(request: CreateArchiveRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.CreateArchiveResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createArchive(request))
  def putPermission(
      request: PutPermissionRequest
  ): ZIO[zio.aws.eventbridge.EventBridge, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putPermission(request))
  def deleteEventBus(
      request: DeleteEventBusRequest
  ): ZIO[zio.aws.eventbridge.EventBridge, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteEventBus(request))
  def activateEventSource(
      request: ActivateEventSourceRequest
  ): ZIO[zio.aws.eventbridge.EventBridge, AwsError, Unit] =
    ZIO.serviceWithZIO(_.activateEventSource(request))
  def listArchives(request: ListArchivesRequest): ZStream[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.Archive.ReadOnly
  ] = ZStream.serviceWithStream(_.listArchives(request))
  def listArchivesPaginated(request: ListArchivesRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.ListArchivesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listArchivesPaginated(request))
  def createPartnerEventSource(request: CreatePartnerEventSourceRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.CreatePartnerEventSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPartnerEventSource(request))
  def createConnection(request: CreateConnectionRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.CreateConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConnection(request))
  def deleteApiDestination(request: DeleteApiDestinationRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.DeleteApiDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApiDestination(request))
  def describeConnection(request: DescribeConnectionRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.DescribeConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConnection(request))
  def testEventPattern(request: TestEventPatternRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.TestEventPatternResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.testEventPattern(request))
  def updateConnection(request: UpdateConnectionRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.UpdateConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateConnection(request))
  def putTargets(request: PutTargetsRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.PutTargetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putTargets(request))
  def createEventBus(
      request: CreateEventBusRequest
  ): ZIO[zio.aws.eventbridge.EventBridge, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.createEventBus(request))
  def disableRule(
      request: DisableRuleRequest
  ): ZIO[zio.aws.eventbridge.EventBridge, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disableRule(request))
  def listPartnerEventSources(request: ListPartnerEventSourcesRequest): ZStream[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.PartnerEventSource.ReadOnly
  ] = ZStream.serviceWithStream(_.listPartnerEventSources(request))
  def listPartnerEventSourcesPaginated(
      request: ListPartnerEventSourcesRequest
  ): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.ListPartnerEventSourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPartnerEventSourcesPaginated(request))
  def putEvents(request: PutEventsRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.PutEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putEvents(request))
  def deleteRule(
      request: DeleteRuleRequest
  ): ZIO[zio.aws.eventbridge.EventBridge, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRule(request))
  def deleteArchive(request: DeleteArchiveRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.DeleteArchiveResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteArchive(request))
  def deleteEndpoint(request: DeleteEndpointRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.DeleteEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEndpoint(request))
  def listConnections(request: ListConnectionsRequest): ZStream[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.Connection.ReadOnly
  ] = ZStream.serviceWithStream(_.listConnections(request))
  def listConnectionsPaginated(request: ListConnectionsRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.ListConnectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listConnectionsPaginated(request))
  def describePartnerEventSource(
      request: DescribePartnerEventSourceRequest
  ): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.DescribePartnerEventSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePartnerEventSource(request))
  def listEventBuses(request: ListEventBusesRequest): ZStream[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.EventBus.ReadOnly
  ] = ZStream.serviceWithStream(_.listEventBuses(request))
  def listEventBusesPaginated(request: ListEventBusesRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.ListEventBusesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEventBusesPaginated(request))
  def updateArchive(request: UpdateArchiveRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.UpdateArchiveResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateArchive(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def describeEndpoint(request: DescribeEndpointRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.DescribeEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEndpoint(request))
  def putRule(request: PutRuleRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.PutRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putRule(request))
  def describeRule(request: DescribeRuleRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.DescribeRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRule(request))
  def listEventSources(request: ListEventSourcesRequest): ZStream[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.EventSource.ReadOnly
  ] = ZStream.serviceWithStream(_.listEventSources(request))
  def listEventSourcesPaginated(request: ListEventSourcesRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.ListEventSourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEventSourcesPaginated(request))
  def listApiDestinations(request: ListApiDestinationsRequest): ZStream[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.ApiDestination.ReadOnly
  ] = ZStream.serviceWithStream(_.listApiDestinations(request))
  def listApiDestinationsPaginated(request: ListApiDestinationsRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.ListApiDestinationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApiDestinationsPaginated(request))
  def removePermission(
      request: RemovePermissionRequest
  ): ZIO[zio.aws.eventbridge.EventBridge, AwsError, Unit] =
    ZIO.serviceWithZIO(_.removePermission(request))
  def deletePartnerEventSource(
      request: DeletePartnerEventSourceRequest
  ): ZIO[zio.aws.eventbridge.EventBridge, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deletePartnerEventSource(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def describeApiDestination(request: DescribeApiDestinationRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.DescribeApiDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeApiDestination(request))
  def deleteConnection(request: DeleteConnectionRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.DeleteConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteConnection(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def createEndpoint(request: CreateEndpointRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.CreateEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEndpoint(request))
  def listRules(request: ListRulesRequest): ZStream[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.Rule.ReadOnly
  ] = ZStream.serviceWithStream(_.listRules(request))
  def listRulesPaginated(request: ListRulesRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.ListRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRulesPaginated(request))
  def updateEndpoint(request: UpdateEndpointRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.UpdateEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEndpoint(request))
  def listEndpoints(request: ListEndpointsRequest): ZStream[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.Endpoint.ReadOnly
  ] = ZStream.serviceWithStream(_.listEndpoints(request))
  def listEndpointsPaginated(request: ListEndpointsRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.ListEndpointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEndpointsPaginated(request))
  def createApiDestination(request: CreateApiDestinationRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.CreateApiDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApiDestination(request))
  def deauthorizeConnection(request: DeauthorizeConnectionRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.DeauthorizeConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deauthorizeConnection(request))
  def updateApiDestination(request: UpdateApiDestinationRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.UpdateApiDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApiDestination(request))
  def describeReplay(request: DescribeReplayRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.DescribeReplayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReplay(request))
  def listRuleNamesByTarget(
      request: ListRuleNamesByTargetRequest
  ): ZStream[zio.aws.eventbridge.EventBridge, AwsError, RuleName] =
    ZStream.serviceWithStream(_.listRuleNamesByTarget(request))
  def listRuleNamesByTargetPaginated(
      request: ListRuleNamesByTargetRequest
  ): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.ListRuleNamesByTargetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRuleNamesByTargetPaginated(request))
  def listReplays(request: ListReplaysRequest): ZStream[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.Replay.ReadOnly
  ] = ZStream.serviceWithStream(_.listReplays(request))
  def listReplaysPaginated(request: ListReplaysRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.ListReplaysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listReplaysPaginated(request))
  def enableRule(
      request: EnableRuleRequest
  ): ZIO[zio.aws.eventbridge.EventBridge, AwsError, Unit] =
    ZIO.serviceWithZIO(_.enableRule(request))
  def describeEventBus(request: DescribeEventBusRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.DescribeEventBusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventBus(request))
  def startReplay(request: StartReplayRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.StartReplayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startReplay(request))
  def describeEventSource(request: DescribeEventSourceRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.DescribeEventSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventSource(request))
  def putPartnerEvents(request: PutPartnerEventsRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.PutPartnerEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putPartnerEvents(request))
  def removeTargets(request: RemoveTargetsRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.RemoveTargetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeTargets(request))
  def deactivateEventSource(
      request: DeactivateEventSourceRequest
  ): ZIO[zio.aws.eventbridge.EventBridge, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deactivateEventSource(request))
  def listPartnerEventSourceAccounts(
      request: ListPartnerEventSourceAccountsRequest
  ): ZStream[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.PartnerEventSourceAccount.ReadOnly
  ] = ZStream.serviceWithStream(_.listPartnerEventSourceAccounts(request))
  def listPartnerEventSourceAccountsPaginated(
      request: ListPartnerEventSourceAccountsRequest
  ): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.ListPartnerEventSourceAccountsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPartnerEventSourceAccountsPaginated(request))
  def describeArchive(request: DescribeArchiveRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.DescribeArchiveResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeArchive(request))
  def listTargetsByRule(request: ListTargetsByRuleRequest): ZStream[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.Target.ReadOnly
  ] = ZStream.serviceWithStream(_.listTargetsByRule(request))
  def listTargetsByRulePaginated(request: ListTargetsByRuleRequest): ZIO[
    zio.aws.eventbridge.EventBridge,
    AwsError,
    zio.aws.eventbridge.model.ListTargetsByRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTargetsByRulePaginated(request))
}
