package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class BatchRetryStrategy(
    attempts: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.BatchRetryStrategy = {
    import BatchRetryStrategy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.BatchRetryStrategy
      .builder()
      .optionallyWith(attempts.map(value => value: java.lang.Integer))(
        _.attempts
      )
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.BatchRetryStrategy.ReadOnly =
    zio.aws.eventbridge.model.BatchRetryStrategy.wrap(buildAwsValue())
}
object BatchRetryStrategy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.BatchRetryStrategy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.BatchRetryStrategy =
      zio.aws.eventbridge.model.BatchRetryStrategy(attempts.map(value => value))
    def attempts: Optional[Integer]
    def getAttempts: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("attempts", attempts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.BatchRetryStrategy
  ) extends zio.aws.eventbridge.model.BatchRetryStrategy.ReadOnly {
    override val attempts: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.attempts())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.BatchRetryStrategy
  ): zio.aws.eventbridge.model.BatchRetryStrategy.ReadOnly = new Wrapper(impl)
}
