package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{ReplayStateReason, ReplayArn}
import scala.jdk.CollectionConverters.*
final case class CancelReplayResponse(
    replayArn: Optional[ReplayArn] = Optional.Absent,
    state: Optional[zio.aws.eventbridge.model.ReplayState] = Optional.Absent,
    stateReason: Optional[ReplayStateReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.CancelReplayResponse = {
    import CancelReplayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.CancelReplayResponse
      .builder()
      .optionallyWith(
        replayArn.map(value => ReplayArn.unwrap(value): java.lang.String)
      )(_.replayArn)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        stateReason.map(value =>
          ReplayStateReason.unwrap(value): java.lang.String
        )
      )(_.stateReason)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.CancelReplayResponse.ReadOnly =
    zio.aws.eventbridge.model.CancelReplayResponse.wrap(buildAwsValue())
}
object CancelReplayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.CancelReplayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.CancelReplayResponse =
      zio.aws.eventbridge.model.CancelReplayResponse(
        replayArn.map(value => value),
        state.map(value => value),
        stateReason.map(value => value)
      )
    def replayArn: Optional[ReplayArn]
    def state: Optional[zio.aws.eventbridge.model.ReplayState]
    def stateReason: Optional[ReplayStateReason]
    def getReplayArn: ZIO[Any, AwsError, ReplayArn] =
      AwsError.unwrapOptionField("replayArn", replayArn)
    def getState: ZIO[Any, AwsError, zio.aws.eventbridge.model.ReplayState] =
      AwsError.unwrapOptionField("state", state)
    def getStateReason: ZIO[Any, AwsError, ReplayStateReason] =
      AwsError.unwrapOptionField("stateReason", stateReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.CancelReplayResponse
  ) extends zio.aws.eventbridge.model.CancelReplayResponse.ReadOnly {
    override val replayArn: Optional[ReplayArn] = zio.aws.core.internal
      .optionalFromNullable(impl.replayArn())
      .map(value => zio.aws.eventbridge.model.primitives.ReplayArn(value))
    override val state: Optional[zio.aws.eventbridge.model.ReplayState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.eventbridge.model.ReplayState.wrap(value))
    override val stateReason: Optional[ReplayStateReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateReason())
        .map(value =>
          zio.aws.eventbridge.model.primitives.ReplayStateReason(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.CancelReplayResponse
  ): zio.aws.eventbridge.model.CancelReplayResponse.ReadOnly = new Wrapper(impl)
}
