package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.AuthHeaderParameters
import scala.jdk.CollectionConverters.*
final case class ConnectionOAuthClientResponseParameters(
    clientID: Optional[AuthHeaderParameters] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ConnectionOAuthClientResponseParameters = {
    import ConnectionOAuthClientResponseParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ConnectionOAuthClientResponseParameters
      .builder()
      .optionallyWith(
        clientID.map(value =>
          AuthHeaderParameters.unwrap(value): java.lang.String
        )
      )(_.clientID)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.ConnectionOAuthClientResponseParameters.ReadOnly =
    zio.aws.eventbridge.model.ConnectionOAuthClientResponseParameters
      .wrap(buildAwsValue())
}
object ConnectionOAuthClientResponseParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ConnectionOAuthClientResponseParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.eventbridge.model.ConnectionOAuthClientResponseParameters =
      zio.aws.eventbridge.model
        .ConnectionOAuthClientResponseParameters(clientID.map(value => value))
    def clientID: Optional[AuthHeaderParameters]
    def getClientID: ZIO[Any, AwsError, AuthHeaderParameters] =
      AwsError.unwrapOptionField("clientID", clientID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ConnectionOAuthClientResponseParameters
  ) extends zio.aws.eventbridge.model.ConnectionOAuthClientResponseParameters.ReadOnly {
    override val clientID: Optional[AuthHeaderParameters] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientID())
        .map(value =>
          zio.aws.eventbridge.model.primitives.AuthHeaderParameters(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ConnectionOAuthClientResponseParameters
  ): zio.aws.eventbridge.model.ConnectionOAuthClientResponseParameters.ReadOnly =
    new Wrapper(impl)
}
