package zio.aws.eventbridge.model
import scala.jdk.CollectionConverters.*
sealed trait ConnectionState {
  def unwrap: software.amazon.awssdk.services.eventbridge.model.ConnectionState
}
object ConnectionState {
  def wrap(
      value: software.amazon.awssdk.services.eventbridge.model.ConnectionState
  ): zio.aws.eventbridge.model.ConnectionState = value match {
    case software.amazon.awssdk.services.eventbridge.model.ConnectionState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eventbridge.model.ConnectionState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.eventbridge.model.ConnectionState.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.eventbridge.model.ConnectionState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.eventbridge.model.ConnectionState.AUTHORIZED =>
      val r = AUTHORIZED
      r
    case software.amazon.awssdk.services.eventbridge.model.ConnectionState.DEAUTHORIZED =>
      val r = DEAUTHORIZED
      r
    case software.amazon.awssdk.services.eventbridge.model.ConnectionState.AUTHORIZING =>
      val r = AUTHORIZING
      r
    case software.amazon.awssdk.services.eventbridge.model.ConnectionState.DEAUTHORIZING =>
      val r = DEAUTHORIZING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.eventbridge.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ConnectionState =
      software.amazon.awssdk.services.eventbridge.model.ConnectionState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.eventbridge.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ConnectionState =
      software.amazon.awssdk.services.eventbridge.model.ConnectionState.CREATING
  }
  case object UPDATING extends zio.aws.eventbridge.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ConnectionState =
      software.amazon.awssdk.services.eventbridge.model.ConnectionState.UPDATING
  }
  case object DELETING extends zio.aws.eventbridge.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ConnectionState =
      software.amazon.awssdk.services.eventbridge.model.ConnectionState.DELETING
  }
  case object AUTHORIZED extends zio.aws.eventbridge.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ConnectionState =
      software.amazon.awssdk.services.eventbridge.model.ConnectionState.AUTHORIZED
  }
  case object DEAUTHORIZED extends zio.aws.eventbridge.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ConnectionState =
      software.amazon.awssdk.services.eventbridge.model.ConnectionState.DEAUTHORIZED
  }
  case object AUTHORIZING extends zio.aws.eventbridge.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ConnectionState =
      software.amazon.awssdk.services.eventbridge.model.ConnectionState.AUTHORIZING
  }
  case object DEAUTHORIZING extends zio.aws.eventbridge.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ConnectionState =
      software.amazon.awssdk.services.eventbridge.model.ConnectionState.DEAUTHORIZING
  }
}
