package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  HttpsEndpoint,
  ApiDestinationName,
  ConnectionArn,
  ApiDestinationDescription,
  ApiDestinationInvocationRateLimitPerSecond
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateApiDestinationRequest(
    name: ApiDestinationName,
    description: Optional[ApiDestinationDescription] = Optional.Absent,
    connectionArn: ConnectionArn,
    invocationEndpoint: HttpsEndpoint,
    httpMethod: zio.aws.eventbridge.model.ApiDestinationHttpMethod,
    invocationRateLimitPerSecond: Optional[
      ApiDestinationInvocationRateLimitPerSecond
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.CreateApiDestinationRequest = {
    import CreateApiDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.CreateApiDestinationRequest
      .builder()
      .name(ApiDestinationName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ApiDestinationDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .connectionArn(ConnectionArn.unwrap(connectionArn): java.lang.String)
      .invocationEndpoint(
        HttpsEndpoint.unwrap(invocationEndpoint): java.lang.String
      )
      .httpMethod(httpMethod.unwrap)
      .optionallyWith(
        invocationRateLimitPerSecond.map(value =>
          ApiDestinationInvocationRateLimitPerSecond.unwrap(value): Integer
        )
      )(_.invocationRateLimitPerSecond)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.CreateApiDestinationRequest.ReadOnly =
    zio.aws.eventbridge.model.CreateApiDestinationRequest.wrap(buildAwsValue())
}
object CreateApiDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.CreateApiDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.CreateApiDestinationRequest =
      zio.aws.eventbridge.model.CreateApiDestinationRequest(
        name,
        description.map(value => value),
        connectionArn,
        invocationEndpoint,
        httpMethod,
        invocationRateLimitPerSecond.map(value => value)
      )
    def name: ApiDestinationName
    def description: Optional[ApiDestinationDescription]
    def connectionArn: ConnectionArn
    def invocationEndpoint: HttpsEndpoint
    def httpMethod: zio.aws.eventbridge.model.ApiDestinationHttpMethod
    def invocationRateLimitPerSecond
        : Optional[ApiDestinationInvocationRateLimitPerSecond]
    def getName: ZIO[Any, Nothing, ApiDestinationName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, ApiDestinationDescription] =
      AwsError.unwrapOptionField("description", description)
    def getConnectionArn: ZIO[Any, Nothing, ConnectionArn] =
      ZIO.succeed(connectionArn)
    def getInvocationEndpoint: ZIO[Any, Nothing, HttpsEndpoint] =
      ZIO.succeed(invocationEndpoint)
    def getHttpMethod: ZIO[
      Any,
      Nothing,
      zio.aws.eventbridge.model.ApiDestinationHttpMethod
    ] = ZIO.succeed(httpMethod)
    def getInvocationRateLimitPerSecond
        : ZIO[Any, AwsError, ApiDestinationInvocationRateLimitPerSecond] =
      AwsError.unwrapOptionField(
        "invocationRateLimitPerSecond",
        invocationRateLimitPerSecond
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateApiDestinationRequest
  ) extends zio.aws.eventbridge.model.CreateApiDestinationRequest.ReadOnly {
    override val name: ApiDestinationName =
      zio.aws.eventbridge.model.primitives.ApiDestinationName(impl.name())
    override val description: Optional[ApiDestinationDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.eventbridge.model.primitives.ApiDestinationDescription(value)
        )
    override val connectionArn: ConnectionArn =
      zio.aws.eventbridge.model.primitives.ConnectionArn(impl.connectionArn())
    override val invocationEndpoint: HttpsEndpoint =
      zio.aws.eventbridge.model.primitives
        .HttpsEndpoint(impl.invocationEndpoint())
    override val httpMethod
        : zio.aws.eventbridge.model.ApiDestinationHttpMethod =
      zio.aws.eventbridge.model.ApiDestinationHttpMethod.wrap(impl.httpMethod())
    override val invocationRateLimitPerSecond
        : Optional[ApiDestinationInvocationRateLimitPerSecond] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invocationRateLimitPerSecond())
        .map(value =>
          zio.aws.eventbridge.model.primitives
            .ApiDestinationInvocationRateLimitPerSecond(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateApiDestinationRequest
  ): zio.aws.eventbridge.model.CreateApiDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
