package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{Timestamp, ApiDestinationArn}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CreateApiDestinationResponse(
    apiDestinationArn: Optional[ApiDestinationArn] = Optional.Absent,
    apiDestinationState: Optional[
      zio.aws.eventbridge.model.ApiDestinationState
    ] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.CreateApiDestinationResponse = {
    import CreateApiDestinationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.CreateApiDestinationResponse
      .builder()
      .optionallyWith(
        apiDestinationArn.map(value =>
          ApiDestinationArn.unwrap(value): java.lang.String
        )
      )(_.apiDestinationArn)
      .optionallyWith(apiDestinationState.map(value => value.unwrap))(
        _.apiDestinationState
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.CreateApiDestinationResponse.ReadOnly =
    zio.aws.eventbridge.model.CreateApiDestinationResponse.wrap(buildAwsValue())
}
object CreateApiDestinationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.CreateApiDestinationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.CreateApiDestinationResponse =
      zio.aws.eventbridge.model.CreateApiDestinationResponse(
        apiDestinationArn.map(value => value),
        apiDestinationState.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def apiDestinationArn: Optional[ApiDestinationArn]
    def apiDestinationState
        : Optional[zio.aws.eventbridge.model.ApiDestinationState]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def getApiDestinationArn: ZIO[Any, AwsError, ApiDestinationArn] =
      AwsError.unwrapOptionField("apiDestinationArn", apiDestinationArn)
    def getApiDestinationState
        : ZIO[Any, AwsError, zio.aws.eventbridge.model.ApiDestinationState] =
      AwsError.unwrapOptionField("apiDestinationState", apiDestinationState)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateApiDestinationResponse
  ) extends zio.aws.eventbridge.model.CreateApiDestinationResponse.ReadOnly {
    override val apiDestinationArn: Optional[ApiDestinationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiDestinationArn())
        .map(value =>
          zio.aws.eventbridge.model.primitives.ApiDestinationArn(value)
        )
    override val apiDestinationState
        : Optional[zio.aws.eventbridge.model.ApiDestinationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiDestinationState())
        .map(value => zio.aws.eventbridge.model.ApiDestinationState.wrap(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateApiDestinationResponse
  ): zio.aws.eventbridge.model.CreateApiDestinationResponse.ReadOnly =
    new Wrapper(impl)
}
