package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.AuthHeaderParameters
import scala.jdk.CollectionConverters.*
final case class CreateConnectionBasicAuthRequestParameters(
    username: AuthHeaderParameters,
    password: AuthHeaderParameters
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.CreateConnectionBasicAuthRequestParameters = {
    import CreateConnectionBasicAuthRequestParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.CreateConnectionBasicAuthRequestParameters
      .builder()
      .username(AuthHeaderParameters.unwrap(username): java.lang.String)
      .password(AuthHeaderParameters.unwrap(password): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.CreateConnectionBasicAuthRequestParameters.ReadOnly =
    zio.aws.eventbridge.model.CreateConnectionBasicAuthRequestParameters
      .wrap(buildAwsValue())
}
object CreateConnectionBasicAuthRequestParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.CreateConnectionBasicAuthRequestParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.eventbridge.model.CreateConnectionBasicAuthRequestParameters =
      zio.aws.eventbridge.model
        .CreateConnectionBasicAuthRequestParameters(username, password)
    def username: AuthHeaderParameters
    def password: AuthHeaderParameters
    def getUsername: ZIO[Any, Nothing, AuthHeaderParameters] =
      ZIO.succeed(username)
    def getPassword: ZIO[Any, Nothing, AuthHeaderParameters] =
      ZIO.succeed(password)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateConnectionBasicAuthRequestParameters
  ) extends zio.aws.eventbridge.model.CreateConnectionBasicAuthRequestParameters.ReadOnly {
    override val username: AuthHeaderParameters =
      zio.aws.eventbridge.model.primitives.AuthHeaderParameters(impl.username())
    override val password: AuthHeaderParameters =
      zio.aws.eventbridge.model.primitives.AuthHeaderParameters(impl.password())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateConnectionBasicAuthRequestParameters
  ): zio.aws.eventbridge.model.CreateConnectionBasicAuthRequestParameters.ReadOnly =
    new Wrapper(impl)
}
