package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.ResourceArn
import scala.jdk.CollectionConverters.*
final case class DeadLetterConfig(
    arn: Optional[ResourceArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DeadLetterConfig = {
    import DeadLetterConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DeadLetterConfig
      .builder()
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.DeadLetterConfig.ReadOnly =
    zio.aws.eventbridge.model.DeadLetterConfig.wrap(buildAwsValue())
}
object DeadLetterConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DeadLetterConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DeadLetterConfig =
      zio.aws.eventbridge.model.DeadLetterConfig(arn.map(value => value))
    def arn: Optional[ResourceArn]
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DeadLetterConfig
  ) extends zio.aws.eventbridge.model.DeadLetterConfig.ReadOnly {
    override val arn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.eventbridge.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DeadLetterConfig
  ): zio.aws.eventbridge.model.DeadLetterConfig.ReadOnly = new Wrapper(impl)
}
