package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{Timestamp, ConnectionArn}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DeauthorizeConnectionResponse(
    connectionArn: Optional[ConnectionArn] = Optional.Absent,
    connectionState: Optional[zio.aws.eventbridge.model.ConnectionState] =
      Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    lastAuthorizedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DeauthorizeConnectionResponse = {
    import DeauthorizeConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DeauthorizeConnectionResponse
      .builder()
      .optionallyWith(
        connectionArn.map(value =>
          ConnectionArn.unwrap(value): java.lang.String
        )
      )(_.connectionArn)
      .optionallyWith(connectionState.map(value => value.unwrap))(
        _.connectionState
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        lastAuthorizedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastAuthorizedTime)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.DeauthorizeConnectionResponse.ReadOnly =
    zio.aws.eventbridge.model.DeauthorizeConnectionResponse
      .wrap(buildAwsValue())
}
object DeauthorizeConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DeauthorizeConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DeauthorizeConnectionResponse =
      zio.aws.eventbridge.model.DeauthorizeConnectionResponse(
        connectionArn.map(value => value),
        connectionState.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        lastAuthorizedTime.map(value => value)
      )
    def connectionArn: Optional[ConnectionArn]
    def connectionState: Optional[zio.aws.eventbridge.model.ConnectionState]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def lastAuthorizedTime: Optional[Timestamp]
    def getConnectionArn: ZIO[Any, AwsError, ConnectionArn] =
      AwsError.unwrapOptionField("connectionArn", connectionArn)
    def getConnectionState
        : ZIO[Any, AwsError, zio.aws.eventbridge.model.ConnectionState] =
      AwsError.unwrapOptionField("connectionState", connectionState)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastAuthorizedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastAuthorizedTime", lastAuthorizedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DeauthorizeConnectionResponse
  ) extends zio.aws.eventbridge.model.DeauthorizeConnectionResponse.ReadOnly {
    override val connectionArn: Optional[ConnectionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionArn())
      .map(value => zio.aws.eventbridge.model.primitives.ConnectionArn(value))
    override val connectionState
        : Optional[zio.aws.eventbridge.model.ConnectionState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionState())
        .map(value => zio.aws.eventbridge.model.ConnectionState.wrap(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
    override val lastAuthorizedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastAuthorizedTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DeauthorizeConnectionResponse
  ): zio.aws.eventbridge.model.DeauthorizeConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
