package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.ApiDestinationName
import scala.jdk.CollectionConverters.*
final case class DeleteApiDestinationRequest(name: ApiDestinationName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DeleteApiDestinationRequest = {
    import DeleteApiDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DeleteApiDestinationRequest
      .builder()
      .name(ApiDestinationName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.DeleteApiDestinationRequest.ReadOnly =
    zio.aws.eventbridge.model.DeleteApiDestinationRequest.wrap(buildAwsValue())
}
object DeleteApiDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DeleteApiDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DeleteApiDestinationRequest =
      zio.aws.eventbridge.model.DeleteApiDestinationRequest(name)
    def name: ApiDestinationName
    def getName: ZIO[Any, Nothing, ApiDestinationName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DeleteApiDestinationRequest
  ) extends zio.aws.eventbridge.model.DeleteApiDestinationRequest.ReadOnly {
    override val name: ApiDestinationName =
      zio.aws.eventbridge.model.primitives.ApiDestinationName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DeleteApiDestinationRequest
  ): zio.aws.eventbridge.model.DeleteApiDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
