package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.ArchiveName
import scala.jdk.CollectionConverters.*
final case class DeleteArchiveRequest(archiveName: ArchiveName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DeleteArchiveRequest = {
    import DeleteArchiveRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DeleteArchiveRequest
      .builder()
      .archiveName(ArchiveName.unwrap(archiveName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.DeleteArchiveRequest.ReadOnly =
    zio.aws.eventbridge.model.DeleteArchiveRequest.wrap(buildAwsValue())
}
object DeleteArchiveRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DeleteArchiveRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DeleteArchiveRequest =
      zio.aws.eventbridge.model.DeleteArchiveRequest(archiveName)
    def archiveName: ArchiveName
    def getArchiveName: ZIO[Any, Nothing, ArchiveName] =
      ZIO.succeed(archiveName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DeleteArchiveRequest
  ) extends zio.aws.eventbridge.model.DeleteArchiveRequest.ReadOnly {
    override val archiveName: ArchiveName =
      zio.aws.eventbridge.model.primitives.ArchiveName(impl.archiveName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DeleteArchiveRequest
  ): zio.aws.eventbridge.model.DeleteArchiveRequest.ReadOnly = new Wrapper(impl)
}
