package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.ConnectionName
import scala.jdk.CollectionConverters.*
final case class DeleteConnectionRequest(name: ConnectionName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DeleteConnectionRequest = {
    import DeleteConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DeleteConnectionRequest
      .builder()
      .name(ConnectionName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.DeleteConnectionRequest.ReadOnly =
    zio.aws.eventbridge.model.DeleteConnectionRequest.wrap(buildAwsValue())
}
object DeleteConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DeleteConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DeleteConnectionRequest =
      zio.aws.eventbridge.model.DeleteConnectionRequest(name)
    def name: ConnectionName
    def getName: ZIO[Any, Nothing, ConnectionName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DeleteConnectionRequest
  ) extends zio.aws.eventbridge.model.DeleteConnectionRequest.ReadOnly {
    override val name: ConnectionName =
      zio.aws.eventbridge.model.primitives.ConnectionName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DeleteConnectionRequest
  ): zio.aws.eventbridge.model.DeleteConnectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
