package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.EndpointName
import scala.jdk.CollectionConverters.*
final case class DeleteEndpointRequest(name: EndpointName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DeleteEndpointRequest = {
    import DeleteEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DeleteEndpointRequest
      .builder()
      .name(EndpointName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.DeleteEndpointRequest.ReadOnly =
    zio.aws.eventbridge.model.DeleteEndpointRequest.wrap(buildAwsValue())
}
object DeleteEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DeleteEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DeleteEndpointRequest =
      zio.aws.eventbridge.model.DeleteEndpointRequest(name)
    def name: EndpointName
    def getName: ZIO[Any, Nothing, EndpointName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DeleteEndpointRequest
  ) extends zio.aws.eventbridge.model.DeleteEndpointRequest.ReadOnly {
    override val name: EndpointName =
      zio.aws.eventbridge.model.primitives.EndpointName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DeleteEndpointRequest
  ): zio.aws.eventbridge.model.DeleteEndpointRequest.ReadOnly = new Wrapper(
    impl
  )
}
