package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{EventBusNameOrArn, RuleName}
import scala.jdk.CollectionConverters.*
final case class DeleteRuleRequest(
    name: RuleName,
    eventBusName: Optional[EventBusNameOrArn] = Optional.Absent,
    force: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DeleteRuleRequest = {
    import DeleteRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DeleteRuleRequest
      .builder()
      .name(RuleName.unwrap(name): java.lang.String)
      .optionallyWith(
        eventBusName.map(value =>
          EventBusNameOrArn.unwrap(value): java.lang.String
        )
      )(_.eventBusName)
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.DeleteRuleRequest.ReadOnly =
    zio.aws.eventbridge.model.DeleteRuleRequest.wrap(buildAwsValue())
}
object DeleteRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DeleteRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DeleteRuleRequest =
      zio.aws.eventbridge.model.DeleteRuleRequest(
        name,
        eventBusName.map(value => value),
        force.map(value => value)
      )
    def name: RuleName
    def eventBusName: Optional[EventBusNameOrArn]
    def force: Optional[Boolean]
    def getName: ZIO[Any, Nothing, RuleName] = ZIO.succeed(name)
    def getEventBusName: ZIO[Any, AwsError, EventBusNameOrArn] =
      AwsError.unwrapOptionField("eventBusName", eventBusName)
    def getForce: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("force", force)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DeleteRuleRequest
  ) extends zio.aws.eventbridge.model.DeleteRuleRequest.ReadOnly {
    override val name: RuleName =
      zio.aws.eventbridge.model.primitives.RuleName(impl.name())
    override val eventBusName: Optional[EventBusNameOrArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventBusName())
        .map(value =>
          zio.aws.eventbridge.model.primitives.EventBusNameOrArn(value)
        )
    override val force: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.force())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DeleteRuleRequest
  ): zio.aws.eventbridge.model.DeleteRuleRequest.ReadOnly = new Wrapper(impl)
}
