package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  HttpsEndpoint,
  ApiDestinationName,
  Timestamp,
  ApiDestinationArn,
  ConnectionArn,
  ApiDestinationDescription,
  ApiDestinationInvocationRateLimitPerSecond
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeApiDestinationResponse(
    apiDestinationArn: Optional[ApiDestinationArn] = Optional.Absent,
    name: Optional[ApiDestinationName] = Optional.Absent,
    description: Optional[ApiDestinationDescription] = Optional.Absent,
    apiDestinationState: Optional[
      zio.aws.eventbridge.model.ApiDestinationState
    ] = Optional.Absent,
    connectionArn: Optional[ConnectionArn] = Optional.Absent,
    invocationEndpoint: Optional[HttpsEndpoint] = Optional.Absent,
    httpMethod: Optional[zio.aws.eventbridge.model.ApiDestinationHttpMethod] =
      Optional.Absent,
    invocationRateLimitPerSecond: Optional[
      ApiDestinationInvocationRateLimitPerSecond
    ] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DescribeApiDestinationResponse = {
    import DescribeApiDestinationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DescribeApiDestinationResponse
      .builder()
      .optionallyWith(
        apiDestinationArn.map(value =>
          ApiDestinationArn.unwrap(value): java.lang.String
        )
      )(_.apiDestinationArn)
      .optionallyWith(
        name.map(value => ApiDestinationName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ApiDestinationDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(apiDestinationState.map(value => value.unwrap))(
        _.apiDestinationState
      )
      .optionallyWith(
        connectionArn.map(value =>
          ConnectionArn.unwrap(value): java.lang.String
        )
      )(_.connectionArn)
      .optionallyWith(
        invocationEndpoint.map(value =>
          HttpsEndpoint.unwrap(value): java.lang.String
        )
      )(_.invocationEndpoint)
      .optionallyWith(httpMethod.map(value => value.unwrap))(_.httpMethod)
      .optionallyWith(
        invocationRateLimitPerSecond.map(value =>
          ApiDestinationInvocationRateLimitPerSecond.unwrap(value): Integer
        )
      )(_.invocationRateLimitPerSecond)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.DescribeApiDestinationResponse.ReadOnly =
    zio.aws.eventbridge.model.DescribeApiDestinationResponse
      .wrap(buildAwsValue())
}
object DescribeApiDestinationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DescribeApiDestinationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DescribeApiDestinationResponse =
      zio.aws.eventbridge.model.DescribeApiDestinationResponse(
        apiDestinationArn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        apiDestinationState.map(value => value),
        connectionArn.map(value => value),
        invocationEndpoint.map(value => value),
        httpMethod.map(value => value),
        invocationRateLimitPerSecond.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def apiDestinationArn: Optional[ApiDestinationArn]
    def name: Optional[ApiDestinationName]
    def description: Optional[ApiDestinationDescription]
    def apiDestinationState
        : Optional[zio.aws.eventbridge.model.ApiDestinationState]
    def connectionArn: Optional[ConnectionArn]
    def invocationEndpoint: Optional[HttpsEndpoint]
    def httpMethod: Optional[zio.aws.eventbridge.model.ApiDestinationHttpMethod]
    def invocationRateLimitPerSecond
        : Optional[ApiDestinationInvocationRateLimitPerSecond]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def getApiDestinationArn: ZIO[Any, AwsError, ApiDestinationArn] =
      AwsError.unwrapOptionField("apiDestinationArn", apiDestinationArn)
    def getName: ZIO[Any, AwsError, ApiDestinationName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ApiDestinationDescription] =
      AwsError.unwrapOptionField("description", description)
    def getApiDestinationState
        : ZIO[Any, AwsError, zio.aws.eventbridge.model.ApiDestinationState] =
      AwsError.unwrapOptionField("apiDestinationState", apiDestinationState)
    def getConnectionArn: ZIO[Any, AwsError, ConnectionArn] =
      AwsError.unwrapOptionField("connectionArn", connectionArn)
    def getInvocationEndpoint: ZIO[Any, AwsError, HttpsEndpoint] =
      AwsError.unwrapOptionField("invocationEndpoint", invocationEndpoint)
    def getHttpMethod: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.ApiDestinationHttpMethod
    ] = AwsError.unwrapOptionField("httpMethod", httpMethod)
    def getInvocationRateLimitPerSecond
        : ZIO[Any, AwsError, ApiDestinationInvocationRateLimitPerSecond] =
      AwsError.unwrapOptionField(
        "invocationRateLimitPerSecond",
        invocationRateLimitPerSecond
      )
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeApiDestinationResponse
  ) extends zio.aws.eventbridge.model.DescribeApiDestinationResponse.ReadOnly {
    override val apiDestinationArn: Optional[ApiDestinationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiDestinationArn())
        .map(value =>
          zio.aws.eventbridge.model.primitives.ApiDestinationArn(value)
        )
    override val name: Optional[ApiDestinationName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.eventbridge.model.primitives.ApiDestinationName(value)
      )
    override val description: Optional[ApiDestinationDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.eventbridge.model.primitives.ApiDestinationDescription(value)
        )
    override val apiDestinationState
        : Optional[zio.aws.eventbridge.model.ApiDestinationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiDestinationState())
        .map(value => zio.aws.eventbridge.model.ApiDestinationState.wrap(value))
    override val connectionArn: Optional[ConnectionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionArn())
      .map(value => zio.aws.eventbridge.model.primitives.ConnectionArn(value))
    override val invocationEndpoint: Optional[HttpsEndpoint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invocationEndpoint())
        .map(value => zio.aws.eventbridge.model.primitives.HttpsEndpoint(value))
    override val httpMethod
        : Optional[zio.aws.eventbridge.model.ApiDestinationHttpMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpMethod())
        .map(value =>
          zio.aws.eventbridge.model.ApiDestinationHttpMethod.wrap(value)
        )
    override val invocationRateLimitPerSecond
        : Optional[ApiDestinationInvocationRateLimitPerSecond] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invocationRateLimitPerSecond())
        .map(value =>
          zio.aws.eventbridge.model.primitives
            .ApiDestinationInvocationRateLimitPerSecond(value)
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeApiDestinationResponse
  ): zio.aws.eventbridge.model.DescribeApiDestinationResponse.ReadOnly =
    new Wrapper(impl)
}
