package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.ArchiveName
import scala.jdk.CollectionConverters.*
final case class DescribeArchiveRequest(archiveName: ArchiveName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DescribeArchiveRequest = {
    import DescribeArchiveRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DescribeArchiveRequest
      .builder()
      .archiveName(ArchiveName.unwrap(archiveName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.DescribeArchiveRequest.ReadOnly =
    zio.aws.eventbridge.model.DescribeArchiveRequest.wrap(buildAwsValue())
}
object DescribeArchiveRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DescribeArchiveRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DescribeArchiveRequest =
      zio.aws.eventbridge.model.DescribeArchiveRequest(archiveName)
    def archiveName: ArchiveName
    def getArchiveName: ZIO[Any, Nothing, ArchiveName] =
      ZIO.succeed(archiveName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeArchiveRequest
  ) extends zio.aws.eventbridge.model.DescribeArchiveRequest.ReadOnly {
    override val archiveName: ArchiveName =
      zio.aws.eventbridge.model.primitives.ArchiveName(impl.archiveName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeArchiveRequest
  ): zio.aws.eventbridge.model.DescribeArchiveRequest.ReadOnly = new Wrapper(
    impl
  )
}
