package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeEventBusResponse(
    name: Optional[String] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    policy: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DescribeEventBusResponse = {
    import DescribeEventBusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DescribeEventBusResponse
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(policy.map(value => value: java.lang.String))(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.DescribeEventBusResponse.ReadOnly =
    zio.aws.eventbridge.model.DescribeEventBusResponse.wrap(buildAwsValue())
}
object DescribeEventBusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DescribeEventBusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DescribeEventBusResponse =
      zio.aws.eventbridge.model.DescribeEventBusResponse(
        name.map(value => value),
        arn.map(value => value),
        policy.map(value => value)
      )
    def name: Optional[String]
    def arn: Optional[String]
    def policy: Optional[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getPolicy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeEventBusResponse
  ) extends zio.aws.eventbridge.model.DescribeEventBusResponse.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val policy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeEventBusResponse
  ): zio.aws.eventbridge.model.DescribeEventBusResponse.ReadOnly = new Wrapper(
    impl
  )
}
