package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{EventBusNameOrArn, RuleName}
import scala.jdk.CollectionConverters.*
final case class EnableRuleRequest(
    name: RuleName,
    eventBusName: Optional[EventBusNameOrArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.EnableRuleRequest = {
    import EnableRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.EnableRuleRequest
      .builder()
      .name(RuleName.unwrap(name): java.lang.String)
      .optionallyWith(
        eventBusName.map(value =>
          EventBusNameOrArn.unwrap(value): java.lang.String
        )
      )(_.eventBusName)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.EnableRuleRequest.ReadOnly =
    zio.aws.eventbridge.model.EnableRuleRequest.wrap(buildAwsValue())
}
object EnableRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.EnableRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.EnableRuleRequest =
      zio.aws.eventbridge.model
        .EnableRuleRequest(name, eventBusName.map(value => value))
    def name: RuleName
    def eventBusName: Optional[EventBusNameOrArn]
    def getName: ZIO[Any, Nothing, RuleName] = ZIO.succeed(name)
    def getEventBusName: ZIO[Any, AwsError, EventBusNameOrArn] =
      AwsError.unwrapOptionField("eventBusName", eventBusName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.EnableRuleRequest
  ) extends zio.aws.eventbridge.model.EnableRuleRequest.ReadOnly {
    override val name: RuleName =
      zio.aws.eventbridge.model.primitives.RuleName(impl.name())
    override val eventBusName: Optional[EventBusNameOrArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventBusName())
        .map(value =>
          zio.aws.eventbridge.model.primitives.EventBusNameOrArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.EnableRuleRequest
  ): zio.aws.eventbridge.model.EnableRuleRequest.ReadOnly = new Wrapper(impl)
}
