package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.Timestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class EventSource(
    arn: Optional[String] = Optional.Absent,
    createdBy: Optional[String] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    expirationTime: Optional[Timestamp] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.eventbridge.model.EventSourceState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.EventSource = {
    import EventSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.EventSource
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(createdBy.map(value => value: java.lang.String))(
        _.createdBy
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        expirationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.expirationTime)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.EventSource.ReadOnly =
    zio.aws.eventbridge.model.EventSource.wrap(buildAwsValue())
}
object EventSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.EventSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.EventSource =
      zio.aws.eventbridge.model.EventSource(
        arn.map(value => value),
        createdBy.map(value => value),
        creationTime.map(value => value),
        expirationTime.map(value => value),
        name.map(value => value),
        state.map(value => value)
      )
    def arn: Optional[String]
    def createdBy: Optional[String]
    def creationTime: Optional[Timestamp]
    def expirationTime: Optional[Timestamp]
    def name: Optional[String]
    def state: Optional[zio.aws.eventbridge.model.EventSourceState]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getExpirationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expirationTime", expirationTime)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getState
        : ZIO[Any, AwsError, zio.aws.eventbridge.model.EventSourceState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.EventSource
  ) extends zio.aws.eventbridge.model.EventSource.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val createdBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => value: String)
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
    override val expirationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expirationTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val state: Optional[zio.aws.eventbridge.model.EventSourceState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.eventbridge.model.EventSourceState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.EventSource
  ): zio.aws.eventbridge.model.EventSource.ReadOnly = new Wrapper(impl)
}
