package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class FailoverConfig(
    primary: zio.aws.eventbridge.model.Primary,
    secondary: zio.aws.eventbridge.model.Secondary
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.FailoverConfig = {
    import FailoverConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.FailoverConfig
      .builder()
      .primary(primary.buildAwsValue())
      .secondary(secondary.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.FailoverConfig.ReadOnly =
    zio.aws.eventbridge.model.FailoverConfig.wrap(buildAwsValue())
}
object FailoverConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.FailoverConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.FailoverConfig =
      zio.aws.eventbridge.model
        .FailoverConfig(primary.asEditable, secondary.asEditable)
    def primary: zio.aws.eventbridge.model.Primary.ReadOnly
    def secondary: zio.aws.eventbridge.model.Secondary.ReadOnly
    def getPrimary
        : ZIO[Any, Nothing, zio.aws.eventbridge.model.Primary.ReadOnly] =
      ZIO.succeed(primary)
    def getSecondary
        : ZIO[Any, Nothing, zio.aws.eventbridge.model.Secondary.ReadOnly] =
      ZIO.succeed(secondary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.FailoverConfig
  ) extends zio.aws.eventbridge.model.FailoverConfig.ReadOnly {
    override val primary: zio.aws.eventbridge.model.Primary.ReadOnly =
      zio.aws.eventbridge.model.Primary.wrap(impl.primary())
    override val secondary: zio.aws.eventbridge.model.Secondary.ReadOnly =
      zio.aws.eventbridge.model.Secondary.wrap(impl.secondary())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.FailoverConfig
  ): zio.aws.eventbridge.model.FailoverConfig.ReadOnly = new Wrapper(impl)
}
