package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  LimitMax100,
  NextToken,
  ConnectionArn,
  ApiDestinationName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListApiDestinationsRequest(
    namePrefix: Optional[ApiDestinationName] = Optional.Absent,
    connectionArn: Optional[ConnectionArn] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    limit: Optional[LimitMax100] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ListApiDestinationsRequest = {
    import ListApiDestinationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ListApiDestinationsRequest
      .builder()
      .optionallyWith(
        namePrefix.map(value =>
          ApiDestinationName.unwrap(value): java.lang.String
        )
      )(_.namePrefix)
      .optionallyWith(
        connectionArn.map(value =>
          ConnectionArn.unwrap(value): java.lang.String
        )
      )(_.connectionArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(limit.map(value => LimitMax100.unwrap(value): Integer))(
        _.limit
      )
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.ListApiDestinationsRequest.ReadOnly =
    zio.aws.eventbridge.model.ListApiDestinationsRequest.wrap(buildAwsValue())
}
object ListApiDestinationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ListApiDestinationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ListApiDestinationsRequest =
      zio.aws.eventbridge.model.ListApiDestinationsRequest(
        namePrefix.map(value => value),
        connectionArn.map(value => value),
        nextToken.map(value => value),
        limit.map(value => value)
      )
    def namePrefix: Optional[ApiDestinationName]
    def connectionArn: Optional[ConnectionArn]
    def nextToken: Optional[NextToken]
    def limit: Optional[LimitMax100]
    def getNamePrefix: ZIO[Any, AwsError, ApiDestinationName] =
      AwsError.unwrapOptionField("namePrefix", namePrefix)
    def getConnectionArn: ZIO[Any, AwsError, ConnectionArn] =
      AwsError.unwrapOptionField("connectionArn", connectionArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLimit: ZIO[Any, AwsError, LimitMax100] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ListApiDestinationsRequest
  ) extends zio.aws.eventbridge.model.ListApiDestinationsRequest.ReadOnly {
    override val namePrefix: Optional[ApiDestinationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.namePrefix())
        .map(value =>
          zio.aws.eventbridge.model.primitives.ApiDestinationName(value)
        )
    override val connectionArn: Optional[ConnectionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionArn())
      .map(value => zio.aws.eventbridge.model.primitives.ConnectionArn(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.eventbridge.model.primitives.NextToken(value))
    override val limit: Optional[LimitMax100] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.eventbridge.model.primitives.LimitMax100(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ListApiDestinationsRequest
  ): zio.aws.eventbridge.model.ListApiDestinationsRequest.ReadOnly =
    new Wrapper(impl)
}
