package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListArchivesResponse(
    archives: Optional[Iterable[zio.aws.eventbridge.model.Archive]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ListArchivesResponse = {
    import ListArchivesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ListArchivesResponse
      .builder()
      .optionallyWith(
        archives.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.archives)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.ListArchivesResponse.ReadOnly =
    zio.aws.eventbridge.model.ListArchivesResponse.wrap(buildAwsValue())
}
object ListArchivesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ListArchivesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ListArchivesResponse =
      zio.aws.eventbridge.model.ListArchivesResponse(
        archives.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def archives: Optional[List[zio.aws.eventbridge.model.Archive.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getArchives
        : ZIO[Any, AwsError, List[zio.aws.eventbridge.model.Archive.ReadOnly]] =
      AwsError.unwrapOptionField("archives", archives)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ListArchivesResponse
  ) extends zio.aws.eventbridge.model.ListArchivesResponse.ReadOnly {
    override val archives
        : Optional[List[zio.aws.eventbridge.model.Archive.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.archives())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eventbridge.model.Archive.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.eventbridge.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ListArchivesResponse
  ): zio.aws.eventbridge.model.ListArchivesResponse.ReadOnly = new Wrapper(impl)
}
