package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  LimitMax100,
  NextToken,
  EventBusName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListEventBusesRequest(
    namePrefix: Optional[EventBusName] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    limit: Optional[LimitMax100] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ListEventBusesRequest = {
    import ListEventBusesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ListEventBusesRequest
      .builder()
      .optionallyWith(
        namePrefix.map(value => EventBusName.unwrap(value): java.lang.String)
      )(_.namePrefix)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(limit.map(value => LimitMax100.unwrap(value): Integer))(
        _.limit
      )
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.ListEventBusesRequest.ReadOnly =
    zio.aws.eventbridge.model.ListEventBusesRequest.wrap(buildAwsValue())
}
object ListEventBusesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ListEventBusesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ListEventBusesRequest =
      zio.aws.eventbridge.model.ListEventBusesRequest(
        namePrefix.map(value => value),
        nextToken.map(value => value),
        limit.map(value => value)
      )
    def namePrefix: Optional[EventBusName]
    def nextToken: Optional[NextToken]
    def limit: Optional[LimitMax100]
    def getNamePrefix: ZIO[Any, AwsError, EventBusName] =
      AwsError.unwrapOptionField("namePrefix", namePrefix)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLimit: ZIO[Any, AwsError, LimitMax100] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ListEventBusesRequest
  ) extends zio.aws.eventbridge.model.ListEventBusesRequest.ReadOnly {
    override val namePrefix: Optional[EventBusName] = zio.aws.core.internal
      .optionalFromNullable(impl.namePrefix())
      .map(value => zio.aws.eventbridge.model.primitives.EventBusName(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.eventbridge.model.primitives.NextToken(value))
    override val limit: Optional[LimitMax100] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.eventbridge.model.primitives.LimitMax100(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ListEventBusesRequest
  ): zio.aws.eventbridge.model.ListEventBusesRequest.ReadOnly = new Wrapper(
    impl
  )
}
