package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  LimitMax100,
  NextToken,
  EventSourceName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListPartnerEventSourceAccountsRequest(
    eventSourceName: EventSourceName,
    nextToken: Optional[NextToken] = Optional.Absent,
    limit: Optional[LimitMax100] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourceAccountsRequest = {
    import ListPartnerEventSourceAccountsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourceAccountsRequest
      .builder()
      .eventSourceName(
        EventSourceName.unwrap(eventSourceName): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(limit.map(value => LimitMax100.unwrap(value): Integer))(
        _.limit
      )
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.ListPartnerEventSourceAccountsRequest.ReadOnly =
    zio.aws.eventbridge.model.ListPartnerEventSourceAccountsRequest
      .wrap(buildAwsValue())
}
object ListPartnerEventSourceAccountsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourceAccountsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.eventbridge.model.ListPartnerEventSourceAccountsRequest =
      zio.aws.eventbridge.model.ListPartnerEventSourceAccountsRequest(
        eventSourceName,
        nextToken.map(value => value),
        limit.map(value => value)
      )
    def eventSourceName: EventSourceName
    def nextToken: Optional[NextToken]
    def limit: Optional[LimitMax100]
    def getEventSourceName: ZIO[Any, Nothing, EventSourceName] =
      ZIO.succeed(eventSourceName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLimit: ZIO[Any, AwsError, LimitMax100] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourceAccountsRequest
  ) extends zio.aws.eventbridge.model.ListPartnerEventSourceAccountsRequest.ReadOnly {
    override val eventSourceName: EventSourceName =
      zio.aws.eventbridge.model.primitives
        .EventSourceName(impl.eventSourceName())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.eventbridge.model.primitives.NextToken(value))
    override val limit: Optional[LimitMax100] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.eventbridge.model.primitives.LimitMax100(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourceAccountsRequest
  ): zio.aws.eventbridge.model.ListPartnerEventSourceAccountsRequest.ReadOnly =
    new Wrapper(impl)
}
