package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  LimitMax100,
  NextToken,
  EventBusNameOrArn,
  TargetArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListRuleNamesByTargetRequest(
    targetArn: TargetArn,
    eventBusName: Optional[EventBusNameOrArn] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    limit: Optional[LimitMax100] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ListRuleNamesByTargetRequest = {
    import ListRuleNamesByTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ListRuleNamesByTargetRequest
      .builder()
      .targetArn(TargetArn.unwrap(targetArn): java.lang.String)
      .optionallyWith(
        eventBusName.map(value =>
          EventBusNameOrArn.unwrap(value): java.lang.String
        )
      )(_.eventBusName)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(limit.map(value => LimitMax100.unwrap(value): Integer))(
        _.limit
      )
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.ListRuleNamesByTargetRequest.ReadOnly =
    zio.aws.eventbridge.model.ListRuleNamesByTargetRequest.wrap(buildAwsValue())
}
object ListRuleNamesByTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ListRuleNamesByTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ListRuleNamesByTargetRequest =
      zio.aws.eventbridge.model.ListRuleNamesByTargetRequest(
        targetArn,
        eventBusName.map(value => value),
        nextToken.map(value => value),
        limit.map(value => value)
      )
    def targetArn: TargetArn
    def eventBusName: Optional[EventBusNameOrArn]
    def nextToken: Optional[NextToken]
    def limit: Optional[LimitMax100]
    def getTargetArn: ZIO[Any, Nothing, TargetArn] = ZIO.succeed(targetArn)
    def getEventBusName: ZIO[Any, AwsError, EventBusNameOrArn] =
      AwsError.unwrapOptionField("eventBusName", eventBusName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLimit: ZIO[Any, AwsError, LimitMax100] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ListRuleNamesByTargetRequest
  ) extends zio.aws.eventbridge.model.ListRuleNamesByTargetRequest.ReadOnly {
    override val targetArn: TargetArn =
      zio.aws.eventbridge.model.primitives.TargetArn(impl.targetArn())
    override val eventBusName: Optional[EventBusNameOrArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventBusName())
        .map(value =>
          zio.aws.eventbridge.model.primitives.EventBusNameOrArn(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.eventbridge.model.primitives.NextToken(value))
    override val limit: Optional[LimitMax100] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.eventbridge.model.primitives.LimitMax100(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ListRuleNamesByTargetRequest
  ): zio.aws.eventbridge.model.ListRuleNamesByTargetRequest.ReadOnly =
    new Wrapper(impl)
}
