package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceARN: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ListTagsForResourceRequest
      .builder()
      .resourceARN(Arn.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.eventbridge.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ListTagsForResourceRequest =
      zio.aws.eventbridge.model.ListTagsForResourceRequest(resourceARN)
    def resourceARN: Arn
    def getResourceARN: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ListTagsForResourceRequest
  ) extends zio.aws.eventbridge.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceARN: Arn =
      zio.aws.eventbridge.model.primitives.Arn(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ListTagsForResourceRequest
  ): zio.aws.eventbridge.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
