package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.PlacementConstraintExpression
import scala.jdk.CollectionConverters.*
final case class PlacementConstraint(
    `type`: Optional[zio.aws.eventbridge.model.PlacementConstraintType] =
      Optional.Absent,
    expression: Optional[PlacementConstraintExpression] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.PlacementConstraint = {
    import PlacementConstraint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.PlacementConstraint
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        expression.map(value =>
          PlacementConstraintExpression.unwrap(value): java.lang.String
        )
      )(_.expression)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.PlacementConstraint.ReadOnly =
    zio.aws.eventbridge.model.PlacementConstraint.wrap(buildAwsValue())
}
object PlacementConstraint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.PlacementConstraint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.PlacementConstraint =
      zio.aws.eventbridge.model.PlacementConstraint(
        `type`.map(value => value),
        expression.map(value => value)
      )
    def `type`: Optional[zio.aws.eventbridge.model.PlacementConstraintType]
    def expression: Optional[PlacementConstraintExpression]
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.PlacementConstraintType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getExpression: ZIO[Any, AwsError, PlacementConstraintExpression] =
      AwsError.unwrapOptionField("expression", expression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.PlacementConstraint
  ) extends zio.aws.eventbridge.model.PlacementConstraint.ReadOnly {
    override val `type`
        : Optional[zio.aws.eventbridge.model.PlacementConstraintType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.eventbridge.model.PlacementConstraintType.wrap(value)
        )
    override val expression: Optional[PlacementConstraintExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expression())
        .map(value =>
          zio.aws.eventbridge.model.primitives
            .PlacementConstraintExpression(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.PlacementConstraint
  ): zio.aws.eventbridge.model.PlacementConstraint.ReadOnly = new Wrapper(impl)
}
