package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.PlacementStrategyField
import scala.jdk.CollectionConverters.*
final case class PlacementStrategy(
    `type`: Optional[zio.aws.eventbridge.model.PlacementStrategyType] =
      Optional.Absent,
    field: Optional[PlacementStrategyField] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.PlacementStrategy = {
    import PlacementStrategy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.PlacementStrategy
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        field.map(value =>
          PlacementStrategyField.unwrap(value): java.lang.String
        )
      )(_.field)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.PlacementStrategy.ReadOnly =
    zio.aws.eventbridge.model.PlacementStrategy.wrap(buildAwsValue())
}
object PlacementStrategy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.PlacementStrategy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.PlacementStrategy =
      zio.aws.eventbridge.model.PlacementStrategy(
        `type`.map(value => value),
        field.map(value => value)
      )
    def `type`: Optional[zio.aws.eventbridge.model.PlacementStrategyType]
    def field: Optional[PlacementStrategyField]
    def getType
        : ZIO[Any, AwsError, zio.aws.eventbridge.model.PlacementStrategyType] =
      AwsError.unwrapOptionField("type", `type`)
    def getField: ZIO[Any, AwsError, PlacementStrategyField] =
      AwsError.unwrapOptionField("field", field)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.PlacementStrategy
  ) extends zio.aws.eventbridge.model.PlacementStrategy.ReadOnly {
    override val `type`
        : Optional[zio.aws.eventbridge.model.PlacementStrategyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.eventbridge.model.PlacementStrategyType.wrap(value)
        )
    override val field: Optional[PlacementStrategyField] = zio.aws.core.internal
      .optionalFromNullable(impl.field())
      .map(value =>
        zio.aws.eventbridge.model.primitives.PlacementStrategyField(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.PlacementStrategy
  ): zio.aws.eventbridge.model.PlacementStrategy.ReadOnly = new Wrapper(impl)
}
