package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  TraceHeader,
  NonPartnerEventBusNameOrArn,
  EventResource,
  EventTime
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class PutEventsRequestEntry(
    time: Optional[EventTime] = Optional.Absent,
    source: Optional[String] = Optional.Absent,
    resources: Optional[Iterable[EventResource]] = Optional.Absent,
    detailType: Optional[String] = Optional.Absent,
    detail: Optional[String] = Optional.Absent,
    eventBusName: Optional[NonPartnerEventBusNameOrArn] = Optional.Absent,
    traceHeader: Optional[TraceHeader] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.PutEventsRequestEntry = {
    import PutEventsRequestEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.PutEventsRequestEntry
      .builder()
      .optionallyWith(time.map(value => EventTime.unwrap(value): Instant))(
        _.time
      )
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            EventResource.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resources)
      .optionallyWith(detailType.map(value => value: java.lang.String))(
        _.detailType
      )
      .optionallyWith(detail.map(value => value: java.lang.String))(_.detail)
      .optionallyWith(
        eventBusName.map(value =>
          NonPartnerEventBusNameOrArn.unwrap(value): java.lang.String
        )
      )(_.eventBusName)
      .optionallyWith(
        traceHeader.map(value => TraceHeader.unwrap(value): java.lang.String)
      )(_.traceHeader)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.PutEventsRequestEntry.ReadOnly =
    zio.aws.eventbridge.model.PutEventsRequestEntry.wrap(buildAwsValue())
}
object PutEventsRequestEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.PutEventsRequestEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.PutEventsRequestEntry =
      zio.aws.eventbridge.model.PutEventsRequestEntry(
        time.map(value => value),
        source.map(value => value),
        resources.map(value => value),
        detailType.map(value => value),
        detail.map(value => value),
        eventBusName.map(value => value),
        traceHeader.map(value => value)
      )
    def time: Optional[EventTime]
    def source: Optional[String]
    def resources: Optional[List[EventResource]]
    def detailType: Optional[String]
    def detail: Optional[String]
    def eventBusName: Optional[NonPartnerEventBusNameOrArn]
    def traceHeader: Optional[TraceHeader]
    def getTime: ZIO[Any, AwsError, EventTime] =
      AwsError.unwrapOptionField("time", time)
    def getSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", source)
    def getResources: ZIO[Any, AwsError, List[EventResource]] =
      AwsError.unwrapOptionField("resources", resources)
    def getDetailType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("detailType", detailType)
    def getDetail: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("detail", detail)
    def getEventBusName: ZIO[Any, AwsError, NonPartnerEventBusNameOrArn] =
      AwsError.unwrapOptionField("eventBusName", eventBusName)
    def getTraceHeader: ZIO[Any, AwsError, TraceHeader] =
      AwsError.unwrapOptionField("traceHeader", traceHeader)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.PutEventsRequestEntry
  ) extends zio.aws.eventbridge.model.PutEventsRequestEntry.ReadOnly {
    override val time: Optional[EventTime] = zio.aws.core.internal
      .optionalFromNullable(impl.time())
      .map(value => zio.aws.eventbridge.model.primitives.EventTime(value))
    override val source: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value => value: String)
    override val resources: Optional[List[EventResource]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eventbridge.model.primitives.EventResource(item)
          }.toList
        )
    override val detailType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.detailType())
      .map(value => value: String)
    override val detail: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.detail())
      .map(value => value: String)
    override val eventBusName: Optional[NonPartnerEventBusNameOrArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventBusName())
        .map(value =>
          zio.aws.eventbridge.model.primitives
            .NonPartnerEventBusNameOrArn(value)
        )
    override val traceHeader: Optional[TraceHeader] = zio.aws.core.internal
      .optionalFromNullable(impl.traceHeader())
      .map(value => zio.aws.eventbridge.model.primitives.TraceHeader(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.PutEventsRequestEntry
  ): zio.aws.eventbridge.model.PutEventsRequestEntry.ReadOnly = new Wrapper(
    impl
  )
}
