package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class PutEventsResponse(
    failedEntryCount: Optional[Integer] = Optional.Absent,
    entries: Optional[
      Iterable[zio.aws.eventbridge.model.PutEventsResultEntry]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.PutEventsResponse = {
    import PutEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.PutEventsResponse
      .builder()
      .optionallyWith(failedEntryCount.map(value => value: java.lang.Integer))(
        _.failedEntryCount
      )
      .optionallyWith(
        entries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entries)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.PutEventsResponse.ReadOnly =
    zio.aws.eventbridge.model.PutEventsResponse.wrap(buildAwsValue())
}
object PutEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.PutEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.PutEventsResponse =
      zio.aws.eventbridge.model.PutEventsResponse(
        failedEntryCount.map(value => value),
        entries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failedEntryCount: Optional[Integer]
    def entries: Optional[
      List[zio.aws.eventbridge.model.PutEventsResultEntry.ReadOnly]
    ]
    def getFailedEntryCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("failedEntryCount", failedEntryCount)
    def getEntries: ZIO[Any, AwsError, List[
      zio.aws.eventbridge.model.PutEventsResultEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("entries", entries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.PutEventsResponse
  ) extends zio.aws.eventbridge.model.PutEventsResponse.ReadOnly {
    override val failedEntryCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.failedEntryCount())
      .map(value => value: Integer)
    override val entries: Optional[
      List[zio.aws.eventbridge.model.PutEventsResultEntry.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.entries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.eventbridge.model.PutEventsResultEntry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.PutEventsResponse
  ): zio.aws.eventbridge.model.PutEventsResponse.ReadOnly = new Wrapper(impl)
}
