package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutPartnerEventsRequest(
    entries: Iterable[zio.aws.eventbridge.model.PutPartnerEventsRequestEntry]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsRequest = {
    import PutPartnerEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsRequest
      .builder()
      .entries(entries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.PutPartnerEventsRequest.ReadOnly =
    zio.aws.eventbridge.model.PutPartnerEventsRequest.wrap(buildAwsValue())
}
object PutPartnerEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.PutPartnerEventsRequest =
      zio.aws.eventbridge.model.PutPartnerEventsRequest(entries.map { item =>
        item.asEditable
      })
    def entries
        : List[zio.aws.eventbridge.model.PutPartnerEventsRequestEntry.ReadOnly]
    def getEntries: ZIO[Any, Nothing, List[
      zio.aws.eventbridge.model.PutPartnerEventsRequestEntry.ReadOnly
    ]] = ZIO.succeed(entries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsRequest
  ) extends zio.aws.eventbridge.model.PutPartnerEventsRequest.ReadOnly {
    override val entries: List[
      zio.aws.eventbridge.model.PutPartnerEventsRequestEntry.ReadOnly
    ] = impl
      .entries()
      .asScala
      .map { item =>
        zio.aws.eventbridge.model.PutPartnerEventsRequestEntry.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsRequest
  ): zio.aws.eventbridge.model.PutPartnerEventsRequest.ReadOnly = new Wrapper(
    impl
  )
}
