package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class PutPartnerEventsResponse(
    failedEntryCount: Optional[Integer] = Optional.Absent,
    entries: Optional[
      Iterable[zio.aws.eventbridge.model.PutPartnerEventsResultEntry]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsResponse = {
    import PutPartnerEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsResponse
      .builder()
      .optionallyWith(failedEntryCount.map(value => value: java.lang.Integer))(
        _.failedEntryCount
      )
      .optionallyWith(
        entries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entries)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.PutPartnerEventsResponse.ReadOnly =
    zio.aws.eventbridge.model.PutPartnerEventsResponse.wrap(buildAwsValue())
}
object PutPartnerEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.PutPartnerEventsResponse =
      zio.aws.eventbridge.model.PutPartnerEventsResponse(
        failedEntryCount.map(value => value),
        entries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failedEntryCount: Optional[Integer]
    def entries: Optional[
      List[zio.aws.eventbridge.model.PutPartnerEventsResultEntry.ReadOnly]
    ]
    def getFailedEntryCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("failedEntryCount", failedEntryCount)
    def getEntries: ZIO[Any, AwsError, List[
      zio.aws.eventbridge.model.PutPartnerEventsResultEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("entries", entries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsResponse
  ) extends zio.aws.eventbridge.model.PutPartnerEventsResponse.ReadOnly {
    override val failedEntryCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.failedEntryCount())
      .map(value => value: Integer)
    override val entries: Optional[
      List[zio.aws.eventbridge.model.PutPartnerEventsResultEntry.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.entries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.eventbridge.model.PutPartnerEventsResultEntry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsResponse
  ): zio.aws.eventbridge.model.PutPartnerEventsResponse.ReadOnly = new Wrapper(
    impl
  )
}
