package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{ErrorMessage, ErrorCode, EventId}
import scala.jdk.CollectionConverters.*
final case class PutPartnerEventsResultEntry(
    eventId: Optional[EventId] = Optional.Absent,
    errorCode: Optional[ErrorCode] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsResultEntry = {
    import PutPartnerEventsResultEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsResultEntry
      .builder()
      .optionallyWith(
        eventId.map(value => EventId.unwrap(value): java.lang.String)
      )(_.eventId)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.PutPartnerEventsResultEntry.ReadOnly =
    zio.aws.eventbridge.model.PutPartnerEventsResultEntry.wrap(buildAwsValue())
}
object PutPartnerEventsResultEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsResultEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.PutPartnerEventsResultEntry =
      zio.aws.eventbridge.model.PutPartnerEventsResultEntry(
        eventId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def eventId: Optional[EventId]
    def errorCode: Optional[ErrorCode]
    def errorMessage: Optional[ErrorMessage]
    def getEventId: ZIO[Any, AwsError, EventId] =
      AwsError.unwrapOptionField("eventId", eventId)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsResultEntry
  ) extends zio.aws.eventbridge.model.PutPartnerEventsResultEntry.ReadOnly {
    override val eventId: Optional[EventId] = zio.aws.core.internal
      .optionalFromNullable(impl.eventId())
      .map(value => zio.aws.eventbridge.model.primitives.EventId(value))
    override val errorCode: Optional[ErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => zio.aws.eventbridge.model.primitives.ErrorCode(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.eventbridge.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsResultEntry
  ): zio.aws.eventbridge.model.PutPartnerEventsResultEntry.ReadOnly =
    new Wrapper(impl)
}
