package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{
  RoleArn,
  ScheduleExpression,
  EventPattern,
  RuleDescription,
  RuleName,
  EventBusNameOrArn
}
import scala.jdk.CollectionConverters.*
final case class PutRuleRequest(
    name: RuleName,
    scheduleExpression: Optional[ScheduleExpression] = Optional.Absent,
    eventPattern: Optional[EventPattern] = Optional.Absent,
    state: Optional[zio.aws.eventbridge.model.RuleState] = Optional.Absent,
    description: Optional[RuleDescription] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.eventbridge.model.Tag]] = Optional.Absent,
    eventBusName: Optional[EventBusNameOrArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.PutRuleRequest = {
    import PutRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.PutRuleRequest
      .builder()
      .name(RuleName.unwrap(name): java.lang.String)
      .optionallyWith(
        scheduleExpression.map(value =>
          ScheduleExpression.unwrap(value): java.lang.String
        )
      )(_.scheduleExpression)
      .optionallyWith(
        eventPattern.map(value => EventPattern.unwrap(value): java.lang.String)
      )(_.eventPattern)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        description.map(value =>
          RuleDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        eventBusName.map(value =>
          EventBusNameOrArn.unwrap(value): java.lang.String
        )
      )(_.eventBusName)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.PutRuleRequest.ReadOnly =
    zio.aws.eventbridge.model.PutRuleRequest.wrap(buildAwsValue())
}
object PutRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.PutRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.PutRuleRequest =
      zio.aws.eventbridge.model.PutRuleRequest(
        name,
        scheduleExpression.map(value => value),
        eventPattern.map(value => value),
        state.map(value => value),
        description.map(value => value),
        roleArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        eventBusName.map(value => value)
      )
    def name: RuleName
    def scheduleExpression: Optional[ScheduleExpression]
    def eventPattern: Optional[EventPattern]
    def state: Optional[zio.aws.eventbridge.model.RuleState]
    def description: Optional[RuleDescription]
    def roleArn: Optional[RoleArn]
    def tags: Optional[List[zio.aws.eventbridge.model.Tag.ReadOnly]]
    def eventBusName: Optional[EventBusNameOrArn]
    def getName: ZIO[Any, Nothing, RuleName] = ZIO.succeed(name)
    def getScheduleExpression: ZIO[Any, AwsError, ScheduleExpression] =
      AwsError.unwrapOptionField("scheduleExpression", scheduleExpression)
    def getEventPattern: ZIO[Any, AwsError, EventPattern] =
      AwsError.unwrapOptionField("eventPattern", eventPattern)
    def getState: ZIO[Any, AwsError, zio.aws.eventbridge.model.RuleState] =
      AwsError.unwrapOptionField("state", state)
    def getDescription: ZIO[Any, AwsError, RuleDescription] =
      AwsError.unwrapOptionField("description", description)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.eventbridge.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEventBusName: ZIO[Any, AwsError, EventBusNameOrArn] =
      AwsError.unwrapOptionField("eventBusName", eventBusName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.PutRuleRequest
  ) extends zio.aws.eventbridge.model.PutRuleRequest.ReadOnly {
    override val name: RuleName =
      zio.aws.eventbridge.model.primitives.RuleName(impl.name())
    override val scheduleExpression: Optional[ScheduleExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleExpression())
        .map(value =>
          zio.aws.eventbridge.model.primitives.ScheduleExpression(value)
        )
    override val eventPattern: Optional[EventPattern] = zio.aws.core.internal
      .optionalFromNullable(impl.eventPattern())
      .map(value => zio.aws.eventbridge.model.primitives.EventPattern(value))
    override val state: Optional[zio.aws.eventbridge.model.RuleState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.eventbridge.model.RuleState.wrap(value))
    override val description: Optional[RuleDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.eventbridge.model.primitives.RuleDescription(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.eventbridge.model.primitives.RoleArn(value))
    override val tags: Optional[List[zio.aws.eventbridge.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eventbridge.model.Tag.wrap(item)
          }.toList
        )
    override val eventBusName: Optional[EventBusNameOrArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventBusName())
        .map(value =>
          zio.aws.eventbridge.model.primitives.EventBusNameOrArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.PutRuleRequest
  ): zio.aws.eventbridge.model.PutRuleRequest.ReadOnly = new Wrapper(impl)
}
