package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{
  TargetId,
  EventBusNameOrArn,
  RuleName
}
import scala.jdk.CollectionConverters.*
final case class RemoveTargetsRequest(
    rule: RuleName,
    eventBusName: Optional[EventBusNameOrArn] = Optional.Absent,
    ids: Iterable[TargetId],
    force: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.RemoveTargetsRequest = {
    import RemoveTargetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.RemoveTargetsRequest
      .builder()
      .rule(RuleName.unwrap(rule): java.lang.String)
      .optionallyWith(
        eventBusName.map(value =>
          EventBusNameOrArn.unwrap(value): java.lang.String
        )
      )(_.eventBusName)
      .ids(ids.map { item =>
        TargetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.RemoveTargetsRequest.ReadOnly =
    zio.aws.eventbridge.model.RemoveTargetsRequest.wrap(buildAwsValue())
}
object RemoveTargetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.RemoveTargetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.RemoveTargetsRequest =
      zio.aws.eventbridge.model.RemoveTargetsRequest(
        rule,
        eventBusName.map(value => value),
        ids,
        force.map(value => value)
      )
    def rule: RuleName
    def eventBusName: Optional[EventBusNameOrArn]
    def ids: List[TargetId]
    def force: Optional[Boolean]
    def getRule: ZIO[Any, Nothing, RuleName] = ZIO.succeed(rule)
    def getEventBusName: ZIO[Any, AwsError, EventBusNameOrArn] =
      AwsError.unwrapOptionField("eventBusName", eventBusName)
    def getIds: ZIO[Any, Nothing, List[TargetId]] = ZIO.succeed(ids)
    def getForce: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("force", force)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.RemoveTargetsRequest
  ) extends zio.aws.eventbridge.model.RemoveTargetsRequest.ReadOnly {
    override val rule: RuleName =
      zio.aws.eventbridge.model.primitives.RuleName(impl.rule())
    override val eventBusName: Optional[EventBusNameOrArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventBusName())
        .map(value =>
          zio.aws.eventbridge.model.primitives.EventBusNameOrArn(value)
        )
    override val ids: List[TargetId] = impl
      .ids()
      .asScala
      .map { item =>
        zio.aws.eventbridge.model.primitives.TargetId(item)
      }
      .toList
    override val force: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.force())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.RemoveTargetsRequest
  ): zio.aws.eventbridge.model.RemoveTargetsRequest.ReadOnly = new Wrapper(impl)
}
