package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class RemoveTargetsResponse(
    failedEntryCount: Optional[Integer] = Optional.Absent,
    failedEntries: Optional[
      Iterable[zio.aws.eventbridge.model.RemoveTargetsResultEntry]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.RemoveTargetsResponse = {
    import RemoveTargetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.RemoveTargetsResponse
      .builder()
      .optionallyWith(failedEntryCount.map(value => value: java.lang.Integer))(
        _.failedEntryCount
      )
      .optionallyWith(
        failedEntries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedEntries)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.RemoveTargetsResponse.ReadOnly =
    zio.aws.eventbridge.model.RemoveTargetsResponse.wrap(buildAwsValue())
}
object RemoveTargetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.RemoveTargetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.RemoveTargetsResponse =
      zio.aws.eventbridge.model.RemoveTargetsResponse(
        failedEntryCount.map(value => value),
        failedEntries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failedEntryCount: Optional[Integer]
    def failedEntries: Optional[
      List[zio.aws.eventbridge.model.RemoveTargetsResultEntry.ReadOnly]
    ]
    def getFailedEntryCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("failedEntryCount", failedEntryCount)
    def getFailedEntries: ZIO[Any, AwsError, List[
      zio.aws.eventbridge.model.RemoveTargetsResultEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("failedEntries", failedEntries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.RemoveTargetsResponse
  ) extends zio.aws.eventbridge.model.RemoveTargetsResponse.ReadOnly {
    override val failedEntryCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.failedEntryCount())
      .map(value => value: Integer)
    override val failedEntries: Optional[
      List[zio.aws.eventbridge.model.RemoveTargetsResultEntry.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failedEntries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.eventbridge.model.RemoveTargetsResultEntry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.RemoveTargetsResponse
  ): zio.aws.eventbridge.model.RemoveTargetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
