package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  Timestamp,
  ReplayStateReason,
  Arn,
  ReplayName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Replay(
    replayName: Optional[ReplayName] = Optional.Absent,
    eventSourceArn: Optional[Arn] = Optional.Absent,
    state: Optional[zio.aws.eventbridge.model.ReplayState] = Optional.Absent,
    stateReason: Optional[ReplayStateReason] = Optional.Absent,
    eventStartTime: Optional[Timestamp] = Optional.Absent,
    eventEndTime: Optional[Timestamp] = Optional.Absent,
    eventLastReplayedTime: Optional[Timestamp] = Optional.Absent,
    replayStartTime: Optional[Timestamp] = Optional.Absent,
    replayEndTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.Replay = {
    import Replay.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.Replay
      .builder()
      .optionallyWith(
        replayName.map(value => ReplayName.unwrap(value): java.lang.String)
      )(_.replayName)
      .optionallyWith(
        eventSourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.eventSourceArn)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        stateReason.map(value =>
          ReplayStateReason.unwrap(value): java.lang.String
        )
      )(_.stateReason)
      .optionallyWith(
        eventStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.eventStartTime)
      .optionallyWith(
        eventEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.eventEndTime)
      .optionallyWith(
        eventLastReplayedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.eventLastReplayedTime)
      .optionallyWith(
        replayStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.replayStartTime)
      .optionallyWith(
        replayEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.replayEndTime)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.Replay.ReadOnly =
    zio.aws.eventbridge.model.Replay.wrap(buildAwsValue())
}
object Replay {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.Replay
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.Replay =
      zio.aws.eventbridge.model.Replay(
        replayName.map(value => value),
        eventSourceArn.map(value => value),
        state.map(value => value),
        stateReason.map(value => value),
        eventStartTime.map(value => value),
        eventEndTime.map(value => value),
        eventLastReplayedTime.map(value => value),
        replayStartTime.map(value => value),
        replayEndTime.map(value => value)
      )
    def replayName: Optional[ReplayName]
    def eventSourceArn: Optional[Arn]
    def state: Optional[zio.aws.eventbridge.model.ReplayState]
    def stateReason: Optional[ReplayStateReason]
    def eventStartTime: Optional[Timestamp]
    def eventEndTime: Optional[Timestamp]
    def eventLastReplayedTime: Optional[Timestamp]
    def replayStartTime: Optional[Timestamp]
    def replayEndTime: Optional[Timestamp]
    def getReplayName: ZIO[Any, AwsError, ReplayName] =
      AwsError.unwrapOptionField("replayName", replayName)
    def getEventSourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("eventSourceArn", eventSourceArn)
    def getState: ZIO[Any, AwsError, zio.aws.eventbridge.model.ReplayState] =
      AwsError.unwrapOptionField("state", state)
    def getStateReason: ZIO[Any, AwsError, ReplayStateReason] =
      AwsError.unwrapOptionField("stateReason", stateReason)
    def getEventStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("eventStartTime", eventStartTime)
    def getEventEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("eventEndTime", eventEndTime)
    def getEventLastReplayedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("eventLastReplayedTime", eventLastReplayedTime)
    def getReplayStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("replayStartTime", replayStartTime)
    def getReplayEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("replayEndTime", replayEndTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.Replay
  ) extends zio.aws.eventbridge.model.Replay.ReadOnly {
    override val replayName: Optional[ReplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.replayName())
      .map(value => zio.aws.eventbridge.model.primitives.ReplayName(value))
    override val eventSourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.eventSourceArn())
      .map(value => zio.aws.eventbridge.model.primitives.Arn(value))
    override val state: Optional[zio.aws.eventbridge.model.ReplayState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.eventbridge.model.ReplayState.wrap(value))
    override val stateReason: Optional[ReplayStateReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateReason())
        .map(value =>
          zio.aws.eventbridge.model.primitives.ReplayStateReason(value)
        )
    override val eventStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.eventStartTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
    override val eventEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.eventEndTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
    override val eventLastReplayedTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventLastReplayedTime())
        .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
    override val replayStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.replayStartTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
    override val replayEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.replayEndTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.Replay
  ): zio.aws.eventbridge.model.Replay.ReadOnly = new Wrapper(impl)
}
