package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReplicationConfig(
    state: Optional[zio.aws.eventbridge.model.ReplicationState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ReplicationConfig = {
    import ReplicationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ReplicationConfig
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.ReplicationConfig.ReadOnly =
    zio.aws.eventbridge.model.ReplicationConfig.wrap(buildAwsValue())
}
object ReplicationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ReplicationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ReplicationConfig =
      zio.aws.eventbridge.model.ReplicationConfig(state.map(value => value))
    def state: Optional[zio.aws.eventbridge.model.ReplicationState]
    def getState
        : ZIO[Any, AwsError, zio.aws.eventbridge.model.ReplicationState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ReplicationConfig
  ) extends zio.aws.eventbridge.model.ReplicationConfig.ReadOnly {
    override val state: Optional[zio.aws.eventbridge.model.ReplicationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.eventbridge.model.ReplicationState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ReplicationConfig
  ): zio.aws.eventbridge.model.ReplicationConfig.ReadOnly = new Wrapper(impl)
}
