package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{
  RuleArn,
  RoleArn,
  ScheduleExpression,
  EventPattern,
  RuleDescription,
  RuleName,
  ManagedBy,
  EventBusName
}
import scala.jdk.CollectionConverters.*
final case class Rule(
    name: Optional[RuleName] = Optional.Absent,
    arn: Optional[RuleArn] = Optional.Absent,
    eventPattern: Optional[EventPattern] = Optional.Absent,
    state: Optional[zio.aws.eventbridge.model.RuleState] = Optional.Absent,
    description: Optional[RuleDescription] = Optional.Absent,
    scheduleExpression: Optional[ScheduleExpression] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    managedBy: Optional[ManagedBy] = Optional.Absent,
    eventBusName: Optional[EventBusName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.Rule = {
    import Rule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.Rule
      .builder()
      .optionallyWith(
        name.map(value => RuleName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => RuleArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        eventPattern.map(value => EventPattern.unwrap(value): java.lang.String)
      )(_.eventPattern)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        description.map(value =>
          RuleDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        scheduleExpression.map(value =>
          ScheduleExpression.unwrap(value): java.lang.String
        )
      )(_.scheduleExpression)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        managedBy.map(value => ManagedBy.unwrap(value): java.lang.String)
      )(_.managedBy)
      .optionallyWith(
        eventBusName.map(value => EventBusName.unwrap(value): java.lang.String)
      )(_.eventBusName)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.Rule.ReadOnly =
    zio.aws.eventbridge.model.Rule.wrap(buildAwsValue())
}
object Rule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eventbridge.model.Rule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.Rule =
      zio.aws.eventbridge.model.Rule(
        name.map(value => value),
        arn.map(value => value),
        eventPattern.map(value => value),
        state.map(value => value),
        description.map(value => value),
        scheduleExpression.map(value => value),
        roleArn.map(value => value),
        managedBy.map(value => value),
        eventBusName.map(value => value)
      )
    def name: Optional[RuleName]
    def arn: Optional[RuleArn]
    def eventPattern: Optional[EventPattern]
    def state: Optional[zio.aws.eventbridge.model.RuleState]
    def description: Optional[RuleDescription]
    def scheduleExpression: Optional[ScheduleExpression]
    def roleArn: Optional[RoleArn]
    def managedBy: Optional[ManagedBy]
    def eventBusName: Optional[EventBusName]
    def getName: ZIO[Any, AwsError, RuleName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, RuleArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getEventPattern: ZIO[Any, AwsError, EventPattern] =
      AwsError.unwrapOptionField("eventPattern", eventPattern)
    def getState: ZIO[Any, AwsError, zio.aws.eventbridge.model.RuleState] =
      AwsError.unwrapOptionField("state", state)
    def getDescription: ZIO[Any, AwsError, RuleDescription] =
      AwsError.unwrapOptionField("description", description)
    def getScheduleExpression: ZIO[Any, AwsError, ScheduleExpression] =
      AwsError.unwrapOptionField("scheduleExpression", scheduleExpression)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getManagedBy: ZIO[Any, AwsError, ManagedBy] =
      AwsError.unwrapOptionField("managedBy", managedBy)
    def getEventBusName: ZIO[Any, AwsError, EventBusName] =
      AwsError.unwrapOptionField("eventBusName", eventBusName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.Rule
  ) extends zio.aws.eventbridge.model.Rule.ReadOnly {
    override val name: Optional[RuleName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.eventbridge.model.primitives.RuleName(value))
    override val arn: Optional[RuleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.eventbridge.model.primitives.RuleArn(value))
    override val eventPattern: Optional[EventPattern] = zio.aws.core.internal
      .optionalFromNullable(impl.eventPattern())
      .map(value => zio.aws.eventbridge.model.primitives.EventPattern(value))
    override val state: Optional[zio.aws.eventbridge.model.RuleState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.eventbridge.model.RuleState.wrap(value))
    override val description: Optional[RuleDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.eventbridge.model.primitives.RuleDescription(value))
    override val scheduleExpression: Optional[ScheduleExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleExpression())
        .map(value =>
          zio.aws.eventbridge.model.primitives.ScheduleExpression(value)
        )
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.eventbridge.model.primitives.RoleArn(value))
    override val managedBy: Optional[ManagedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.managedBy())
      .map(value => zio.aws.eventbridge.model.primitives.ManagedBy(value))
    override val eventBusName: Optional[EventBusName] = zio.aws.core.internal
      .optionalFromNullable(impl.eventBusName())
      .map(value => zio.aws.eventbridge.model.primitives.EventBusName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.Rule
  ): zio.aws.eventbridge.model.Rule.ReadOnly = new Wrapper(impl)
}
