package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{
  TargetArn,
  RoleArn,
  TargetId,
  TargetInputPath,
  TargetInput
}
import scala.jdk.CollectionConverters.*
final case class Target(
    id: TargetId,
    arn: TargetArn,
    roleArn: Optional[RoleArn] = Optional.Absent,
    input: Optional[TargetInput] = Optional.Absent,
    inputPath: Optional[TargetInputPath] = Optional.Absent,
    inputTransformer: Optional[zio.aws.eventbridge.model.InputTransformer] =
      Optional.Absent,
    kinesisParameters: Optional[zio.aws.eventbridge.model.KinesisParameters] =
      Optional.Absent,
    runCommandParameters: Optional[
      zio.aws.eventbridge.model.RunCommandParameters
    ] = Optional.Absent,
    ecsParameters: Optional[zio.aws.eventbridge.model.EcsParameters] =
      Optional.Absent,
    batchParameters: Optional[zio.aws.eventbridge.model.BatchParameters] =
      Optional.Absent,
    sqsParameters: Optional[zio.aws.eventbridge.model.SqsParameters] =
      Optional.Absent,
    httpParameters: Optional[zio.aws.eventbridge.model.HttpParameters] =
      Optional.Absent,
    redshiftDataParameters: Optional[
      zio.aws.eventbridge.model.RedshiftDataParameters
    ] = Optional.Absent,
    sageMakerPipelineParameters: Optional[
      zio.aws.eventbridge.model.SageMakerPipelineParameters
    ] = Optional.Absent,
    deadLetterConfig: Optional[zio.aws.eventbridge.model.DeadLetterConfig] =
      Optional.Absent,
    retryPolicy: Optional[zio.aws.eventbridge.model.RetryPolicy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.Target = {
    import Target.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.Target
      .builder()
      .id(TargetId.unwrap(id): java.lang.String)
      .arn(TargetArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        input.map(value => TargetInput.unwrap(value): java.lang.String)
      )(_.input)
      .optionallyWith(
        inputPath.map(value => TargetInputPath.unwrap(value): java.lang.String)
      )(_.inputPath)
      .optionallyWith(inputTransformer.map(value => value.buildAwsValue()))(
        _.inputTransformer
      )
      .optionallyWith(kinesisParameters.map(value => value.buildAwsValue()))(
        _.kinesisParameters
      )
      .optionallyWith(runCommandParameters.map(value => value.buildAwsValue()))(
        _.runCommandParameters
      )
      .optionallyWith(ecsParameters.map(value => value.buildAwsValue()))(
        _.ecsParameters
      )
      .optionallyWith(batchParameters.map(value => value.buildAwsValue()))(
        _.batchParameters
      )
      .optionallyWith(sqsParameters.map(value => value.buildAwsValue()))(
        _.sqsParameters
      )
      .optionallyWith(httpParameters.map(value => value.buildAwsValue()))(
        _.httpParameters
      )
      .optionallyWith(
        redshiftDataParameters.map(value => value.buildAwsValue())
      )(_.redshiftDataParameters)
      .optionallyWith(
        sageMakerPipelineParameters.map(value => value.buildAwsValue())
      )(_.sageMakerPipelineParameters)
      .optionallyWith(deadLetterConfig.map(value => value.buildAwsValue()))(
        _.deadLetterConfig
      )
      .optionallyWith(retryPolicy.map(value => value.buildAwsValue()))(
        _.retryPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.Target.ReadOnly =
    zio.aws.eventbridge.model.Target.wrap(buildAwsValue())
}
object Target {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.Target
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.Target =
      zio.aws.eventbridge.model.Target(
        id,
        arn,
        roleArn.map(value => value),
        input.map(value => value),
        inputPath.map(value => value),
        inputTransformer.map(value => value.asEditable),
        kinesisParameters.map(value => value.asEditable),
        runCommandParameters.map(value => value.asEditable),
        ecsParameters.map(value => value.asEditable),
        batchParameters.map(value => value.asEditable),
        sqsParameters.map(value => value.asEditable),
        httpParameters.map(value => value.asEditable),
        redshiftDataParameters.map(value => value.asEditable),
        sageMakerPipelineParameters.map(value => value.asEditable),
        deadLetterConfig.map(value => value.asEditable),
        retryPolicy.map(value => value.asEditable)
      )
    def id: TargetId
    def arn: TargetArn
    def roleArn: Optional[RoleArn]
    def input: Optional[TargetInput]
    def inputPath: Optional[TargetInputPath]
    def inputTransformer
        : Optional[zio.aws.eventbridge.model.InputTransformer.ReadOnly]
    def kinesisParameters
        : Optional[zio.aws.eventbridge.model.KinesisParameters.ReadOnly]
    def runCommandParameters
        : Optional[zio.aws.eventbridge.model.RunCommandParameters.ReadOnly]
    def ecsParameters
        : Optional[zio.aws.eventbridge.model.EcsParameters.ReadOnly]
    def batchParameters
        : Optional[zio.aws.eventbridge.model.BatchParameters.ReadOnly]
    def sqsParameters
        : Optional[zio.aws.eventbridge.model.SqsParameters.ReadOnly]
    def httpParameters
        : Optional[zio.aws.eventbridge.model.HttpParameters.ReadOnly]
    def redshiftDataParameters
        : Optional[zio.aws.eventbridge.model.RedshiftDataParameters.ReadOnly]
    def sageMakerPipelineParameters: Optional[
      zio.aws.eventbridge.model.SageMakerPipelineParameters.ReadOnly
    ]
    def deadLetterConfig
        : Optional[zio.aws.eventbridge.model.DeadLetterConfig.ReadOnly]
    def retryPolicy: Optional[zio.aws.eventbridge.model.RetryPolicy.ReadOnly]
    def getId: ZIO[Any, Nothing, TargetId] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, TargetArn] = ZIO.succeed(arn)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getInput: ZIO[Any, AwsError, TargetInput] =
      AwsError.unwrapOptionField("input", input)
    def getInputPath: ZIO[Any, AwsError, TargetInputPath] =
      AwsError.unwrapOptionField("inputPath", inputPath)
    def getInputTransformer: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.InputTransformer.ReadOnly
    ] = AwsError.unwrapOptionField("inputTransformer", inputTransformer)
    def getKinesisParameters: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.KinesisParameters.ReadOnly
    ] = AwsError.unwrapOptionField("kinesisParameters", kinesisParameters)
    def getRunCommandParameters: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.RunCommandParameters.ReadOnly
    ] = AwsError.unwrapOptionField("runCommandParameters", runCommandParameters)
    def getEcsParameters
        : ZIO[Any, AwsError, zio.aws.eventbridge.model.EcsParameters.ReadOnly] =
      AwsError.unwrapOptionField("ecsParameters", ecsParameters)
    def getBatchParameters: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.BatchParameters.ReadOnly
    ] = AwsError.unwrapOptionField("batchParameters", batchParameters)
    def getSqsParameters
        : ZIO[Any, AwsError, zio.aws.eventbridge.model.SqsParameters.ReadOnly] =
      AwsError.unwrapOptionField("sqsParameters", sqsParameters)
    def getHttpParameters: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.HttpParameters.ReadOnly
    ] = AwsError.unwrapOptionField("httpParameters", httpParameters)
    def getRedshiftDataParameters: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.RedshiftDataParameters.ReadOnly
    ] = AwsError.unwrapOptionField(
      "redshiftDataParameters",
      redshiftDataParameters
    )
    def getSageMakerPipelineParameters: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.SageMakerPipelineParameters.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sageMakerPipelineParameters",
      sageMakerPipelineParameters
    )
    def getDeadLetterConfig: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.DeadLetterConfig.ReadOnly
    ] = AwsError.unwrapOptionField("deadLetterConfig", deadLetterConfig)
    def getRetryPolicy
        : ZIO[Any, AwsError, zio.aws.eventbridge.model.RetryPolicy.ReadOnly] =
      AwsError.unwrapOptionField("retryPolicy", retryPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.Target
  ) extends zio.aws.eventbridge.model.Target.ReadOnly {
    override val id: TargetId =
      zio.aws.eventbridge.model.primitives.TargetId(impl.id())
    override val arn: TargetArn =
      zio.aws.eventbridge.model.primitives.TargetArn(impl.arn())
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.eventbridge.model.primitives.RoleArn(value))
    override val input: Optional[TargetInput] = zio.aws.core.internal
      .optionalFromNullable(impl.input())
      .map(value => zio.aws.eventbridge.model.primitives.TargetInput(value))
    override val inputPath: Optional[TargetInputPath] = zio.aws.core.internal
      .optionalFromNullable(impl.inputPath())
      .map(value => zio.aws.eventbridge.model.primitives.TargetInputPath(value))
    override val inputTransformer
        : Optional[zio.aws.eventbridge.model.InputTransformer.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputTransformer())
        .map(value => zio.aws.eventbridge.model.InputTransformer.wrap(value))
    override val kinesisParameters
        : Optional[zio.aws.eventbridge.model.KinesisParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kinesisParameters())
        .map(value => zio.aws.eventbridge.model.KinesisParameters.wrap(value))
    override val runCommandParameters
        : Optional[zio.aws.eventbridge.model.RunCommandParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runCommandParameters())
        .map(value =>
          zio.aws.eventbridge.model.RunCommandParameters.wrap(value)
        )
    override val ecsParameters
        : Optional[zio.aws.eventbridge.model.EcsParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ecsParameters())
        .map(value => zio.aws.eventbridge.model.EcsParameters.wrap(value))
    override val batchParameters
        : Optional[zio.aws.eventbridge.model.BatchParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.batchParameters())
        .map(value => zio.aws.eventbridge.model.BatchParameters.wrap(value))
    override val sqsParameters
        : Optional[zio.aws.eventbridge.model.SqsParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sqsParameters())
        .map(value => zio.aws.eventbridge.model.SqsParameters.wrap(value))
    override val httpParameters
        : Optional[zio.aws.eventbridge.model.HttpParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpParameters())
        .map(value => zio.aws.eventbridge.model.HttpParameters.wrap(value))
    override val redshiftDataParameters
        : Optional[zio.aws.eventbridge.model.RedshiftDataParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.redshiftDataParameters())
        .map(value =>
          zio.aws.eventbridge.model.RedshiftDataParameters.wrap(value)
        )
    override val sageMakerPipelineParameters: Optional[
      zio.aws.eventbridge.model.SageMakerPipelineParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sageMakerPipelineParameters())
      .map(value =>
        zio.aws.eventbridge.model.SageMakerPipelineParameters.wrap(value)
      )
    override val deadLetterConfig
        : Optional[zio.aws.eventbridge.model.DeadLetterConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deadLetterConfig())
        .map(value => zio.aws.eventbridge.model.DeadLetterConfig.wrap(value))
    override val retryPolicy
        : Optional[zio.aws.eventbridge.model.RetryPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryPolicy())
        .map(value => zio.aws.eventbridge.model.RetryPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.Target
  ): zio.aws.eventbridge.model.Target.ReadOnly = new Wrapper(impl)
}
