package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.AuthHeaderParameters
import scala.jdk.CollectionConverters.*
final case class UpdateConnectionApiKeyAuthRequestParameters(
    apiKeyName: Optional[AuthHeaderParameters] = Optional.Absent,
    apiKeyValue: Optional[AuthHeaderParameters] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.UpdateConnectionApiKeyAuthRequestParameters = {
    import UpdateConnectionApiKeyAuthRequestParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.UpdateConnectionApiKeyAuthRequestParameters
      .builder()
      .optionallyWith(
        apiKeyName.map(value =>
          AuthHeaderParameters.unwrap(value): java.lang.String
        )
      )(_.apiKeyName)
      .optionallyWith(
        apiKeyValue.map(value =>
          AuthHeaderParameters.unwrap(value): java.lang.String
        )
      )(_.apiKeyValue)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.UpdateConnectionApiKeyAuthRequestParameters.ReadOnly =
    zio.aws.eventbridge.model.UpdateConnectionApiKeyAuthRequestParameters
      .wrap(buildAwsValue())
}
object UpdateConnectionApiKeyAuthRequestParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.UpdateConnectionApiKeyAuthRequestParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.eventbridge.model.UpdateConnectionApiKeyAuthRequestParameters =
      zio.aws.eventbridge.model.UpdateConnectionApiKeyAuthRequestParameters(
        apiKeyName.map(value => value),
        apiKeyValue.map(value => value)
      )
    def apiKeyName: Optional[AuthHeaderParameters]
    def apiKeyValue: Optional[AuthHeaderParameters]
    def getApiKeyName: ZIO[Any, AwsError, AuthHeaderParameters] =
      AwsError.unwrapOptionField("apiKeyName", apiKeyName)
    def getApiKeyValue: ZIO[Any, AwsError, AuthHeaderParameters] =
      AwsError.unwrapOptionField("apiKeyValue", apiKeyValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.UpdateConnectionApiKeyAuthRequestParameters
  ) extends zio.aws.eventbridge.model.UpdateConnectionApiKeyAuthRequestParameters.ReadOnly {
    override val apiKeyName: Optional[AuthHeaderParameters] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiKeyName())
        .map(value =>
          zio.aws.eventbridge.model.primitives.AuthHeaderParameters(value)
        )
    override val apiKeyValue: Optional[AuthHeaderParameters] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiKeyValue())
        .map(value =>
          zio.aws.eventbridge.model.primitives.AuthHeaderParameters(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.UpdateConnectionApiKeyAuthRequestParameters
  ): zio.aws.eventbridge.model.UpdateConnectionApiKeyAuthRequestParameters.ReadOnly =
    new Wrapper(impl)
}
