package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.GraphQLOperation
import scala.jdk.CollectionConverters.*
final case class AppSyncParameters(
    graphQLOperation: Optional[GraphQLOperation] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.AppSyncParameters = {
    import AppSyncParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.AppSyncParameters
      .builder()
      .optionallyWith(
        graphQLOperation.map(value =>
          GraphQLOperation.unwrap(value): java.lang.String
        )
      )(_.graphQLOperation)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.AppSyncParameters.ReadOnly =
    zio.aws.eventbridge.model.AppSyncParameters.wrap(buildAwsValue())
}
object AppSyncParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.AppSyncParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.AppSyncParameters =
      zio.aws.eventbridge.model
        .AppSyncParameters(graphQLOperation.map(value => value))
    def graphQLOperation: Optional[GraphQLOperation]
    def getGraphQLOperation: ZIO[Any, AwsError, GraphQLOperation] =
      AwsError.unwrapOptionField("graphQLOperation", graphQLOperation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.AppSyncParameters
  ) extends zio.aws.eventbridge.model.AppSyncParameters.ReadOnly {
    override val graphQLOperation: Optional[GraphQLOperation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.graphQLOperation())
        .map(value =>
          zio.aws.eventbridge.model.primitives.GraphQLOperation(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.AppSyncParameters
  ): zio.aws.eventbridge.model.AppSyncParameters.ReadOnly = new Wrapper(impl)
}
