package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  CapacityProviderStrategyItemBase,
  CapacityProviderStrategyItemWeight,
  CapacityProvider
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CapacityProviderStrategyItem(
    capacityProvider: CapacityProvider,
    weight: Optional[CapacityProviderStrategyItemWeight] = Optional.Absent,
    base: Optional[CapacityProviderStrategyItemBase] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.CapacityProviderStrategyItem = {
    import CapacityProviderStrategyItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.CapacityProviderStrategyItem
      .builder()
      .capacityProvider(
        CapacityProvider.unwrap(capacityProvider): java.lang.String
      )
      .optionallyWith(
        weight.map(value =>
          CapacityProviderStrategyItemWeight.unwrap(value): Integer
        )
      )(_.weight)
      .optionallyWith(
        base.map(value =>
          CapacityProviderStrategyItemBase.unwrap(value): Integer
        )
      )(_.base)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.CapacityProviderStrategyItem.ReadOnly =
    zio.aws.eventbridge.model.CapacityProviderStrategyItem.wrap(buildAwsValue())
}
object CapacityProviderStrategyItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.CapacityProviderStrategyItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.CapacityProviderStrategyItem =
      zio.aws.eventbridge.model.CapacityProviderStrategyItem(
        capacityProvider,
        weight.map(value => value),
        base.map(value => value)
      )
    def capacityProvider: CapacityProvider
    def weight: Optional[CapacityProviderStrategyItemWeight]
    def base: Optional[CapacityProviderStrategyItemBase]
    def getCapacityProvider: ZIO[Any, Nothing, CapacityProvider] =
      ZIO.succeed(capacityProvider)
    def getWeight: ZIO[Any, AwsError, CapacityProviderStrategyItemWeight] =
      AwsError.unwrapOptionField("weight", weight)
    def getBase: ZIO[Any, AwsError, CapacityProviderStrategyItemBase] =
      AwsError.unwrapOptionField("base", base)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.CapacityProviderStrategyItem
  ) extends zio.aws.eventbridge.model.CapacityProviderStrategyItem.ReadOnly {
    override val capacityProvider: CapacityProvider =
      zio.aws.eventbridge.model.primitives
        .CapacityProvider(impl.capacityProvider())
    override val weight: Optional[CapacityProviderStrategyItemWeight] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weight())
        .map(value =>
          zio.aws.eventbridge.model.primitives
            .CapacityProviderStrategyItemWeight(value)
        )
    override val base: Optional[CapacityProviderStrategyItemBase] =
      zio.aws.core.internal
        .optionalFromNullable(impl.base())
        .map(value =>
          zio.aws.eventbridge.model.primitives
            .CapacityProviderStrategyItemBase(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.CapacityProviderStrategyItem
  ): zio.aws.eventbridge.model.CapacityProviderStrategyItem.ReadOnly =
    new Wrapper(impl)
}
