package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.SensitiveString
import scala.jdk.CollectionConverters.*
final case class ConnectionBodyParameter(
    key: Optional[String] = Optional.Absent,
    value: Optional[SensitiveString] = Optional.Absent,
    isValueSecret: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ConnectionBodyParameter = {
    import ConnectionBodyParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ConnectionBodyParameter
      .builder()
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(
        value.map(value => SensitiveString.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(isValueSecret.map(value => value: java.lang.Boolean))(
        _.isValueSecret
      )
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.ConnectionBodyParameter.ReadOnly =
    zio.aws.eventbridge.model.ConnectionBodyParameter.wrap(buildAwsValue())
}
object ConnectionBodyParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ConnectionBodyParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ConnectionBodyParameter =
      zio.aws.eventbridge.model.ConnectionBodyParameter(
        key.map(value => value),
        value.map(value => value),
        isValueSecret.map(value => value)
      )
    def key: Optional[String]
    def value: Optional[SensitiveString]
    def isValueSecret: Optional[Boolean]
    def getKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("value", value)
    def getIsValueSecret: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isValueSecret", isValueSecret)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ConnectionBodyParameter
  ) extends zio.aws.eventbridge.model.ConnectionBodyParameter.ReadOnly {
    override val key: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => value: String)
    override val value: Optional[SensitiveString] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.eventbridge.model.primitives.SensitiveString(value))
    override val isValueSecret: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isValueSecret())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ConnectionBodyParameter
  ): zio.aws.eventbridge.model.ConnectionBodyParameter.ReadOnly = new Wrapper(
    impl
  )
}
