package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConnectionHttpParameters(
    headerParameters: Optional[
      Iterable[zio.aws.eventbridge.model.ConnectionHeaderParameter]
    ] = Optional.Absent,
    queryStringParameters: Optional[
      Iterable[zio.aws.eventbridge.model.ConnectionQueryStringParameter]
    ] = Optional.Absent,
    bodyParameters: Optional[
      Iterable[zio.aws.eventbridge.model.ConnectionBodyParameter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ConnectionHttpParameters = {
    import ConnectionHttpParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ConnectionHttpParameters
      .builder()
      .optionallyWith(
        headerParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.headerParameters)
      .optionallyWith(
        queryStringParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.queryStringParameters)
      .optionallyWith(
        bodyParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bodyParameters)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.ConnectionHttpParameters.ReadOnly =
    zio.aws.eventbridge.model.ConnectionHttpParameters.wrap(buildAwsValue())
}
object ConnectionHttpParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ConnectionHttpParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ConnectionHttpParameters =
      zio.aws.eventbridge.model.ConnectionHttpParameters(
        headerParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        queryStringParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        bodyParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def headerParameters: Optional[
      List[zio.aws.eventbridge.model.ConnectionHeaderParameter.ReadOnly]
    ]
    def queryStringParameters: Optional[
      List[zio.aws.eventbridge.model.ConnectionQueryStringParameter.ReadOnly]
    ]
    def bodyParameters: Optional[
      List[zio.aws.eventbridge.model.ConnectionBodyParameter.ReadOnly]
    ]
    def getHeaderParameters: ZIO[Any, AwsError, List[
      zio.aws.eventbridge.model.ConnectionHeaderParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("headerParameters", headerParameters)
    def getQueryStringParameters: ZIO[Any, AwsError, List[
      zio.aws.eventbridge.model.ConnectionQueryStringParameter.ReadOnly
    ]] =
      AwsError.unwrapOptionField("queryStringParameters", queryStringParameters)
    def getBodyParameters: ZIO[Any, AwsError, List[
      zio.aws.eventbridge.model.ConnectionBodyParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("bodyParameters", bodyParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ConnectionHttpParameters
  ) extends zio.aws.eventbridge.model.ConnectionHttpParameters.ReadOnly {
    override val headerParameters: Optional[
      List[zio.aws.eventbridge.model.ConnectionHeaderParameter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.headerParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.eventbridge.model.ConnectionHeaderParameter.wrap(item)
        }.toList
      )
    override val queryStringParameters: Optional[
      List[zio.aws.eventbridge.model.ConnectionQueryStringParameter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.queryStringParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.eventbridge.model.ConnectionQueryStringParameter.wrap(item)
        }.toList
      )
    override val bodyParameters: Optional[
      List[zio.aws.eventbridge.model.ConnectionBodyParameter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bodyParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.eventbridge.model.ConnectionBodyParameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ConnectionHttpParameters
  ): zio.aws.eventbridge.model.ConnectionHttpParameters.ReadOnly = new Wrapper(
    impl
  )
}
