package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{
  QueryStringValueSensitive,
  QueryStringKey
}
import scala.jdk.CollectionConverters.*
final case class ConnectionQueryStringParameter(
    key: Optional[QueryStringKey] = Optional.Absent,
    value: Optional[QueryStringValueSensitive] = Optional.Absent,
    isValueSecret: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ConnectionQueryStringParameter = {
    import ConnectionQueryStringParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ConnectionQueryStringParameter
      .builder()
      .optionallyWith(
        key.map(value => QueryStringKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value =>
          QueryStringValueSensitive.unwrap(value): java.lang.String
        )
      )(_.value)
      .optionallyWith(isValueSecret.map(value => value: java.lang.Boolean))(
        _.isValueSecret
      )
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.ConnectionQueryStringParameter.ReadOnly =
    zio.aws.eventbridge.model.ConnectionQueryStringParameter
      .wrap(buildAwsValue())
}
object ConnectionQueryStringParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ConnectionQueryStringParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ConnectionQueryStringParameter =
      zio.aws.eventbridge.model.ConnectionQueryStringParameter(
        key.map(value => value),
        value.map(value => value),
        isValueSecret.map(value => value)
      )
    def key: Optional[QueryStringKey]
    def value: Optional[QueryStringValueSensitive]
    def isValueSecret: Optional[Boolean]
    def getKey: ZIO[Any, AwsError, QueryStringKey] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, QueryStringValueSensitive] =
      AwsError.unwrapOptionField("value", value)
    def getIsValueSecret: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isValueSecret", isValueSecret)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ConnectionQueryStringParameter
  ) extends zio.aws.eventbridge.model.ConnectionQueryStringParameter.ReadOnly {
    override val key: Optional[QueryStringKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.eventbridge.model.primitives.QueryStringKey(value))
    override val value: Optional[QueryStringValueSensitive] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value =>
          zio.aws.eventbridge.model.primitives.QueryStringValueSensitive(value)
        )
    override val isValueSecret: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isValueSecret())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ConnectionQueryStringParameter
  ): zio.aws.eventbridge.model.ConnectionQueryStringParameter.ReadOnly =
    new Wrapper(impl)
}
