package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.{
  AuthHeaderParametersSensitive,
  AuthHeaderParameters
}
import scala.jdk.CollectionConverters.*
final case class CreateConnectionApiKeyAuthRequestParameters(
    apiKeyName: AuthHeaderParameters,
    apiKeyValue: AuthHeaderParametersSensitive
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.CreateConnectionApiKeyAuthRequestParameters = {
    import CreateConnectionApiKeyAuthRequestParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.CreateConnectionApiKeyAuthRequestParameters
      .builder()
      .apiKeyName(AuthHeaderParameters.unwrap(apiKeyName): java.lang.String)
      .apiKeyValue(
        AuthHeaderParametersSensitive.unwrap(apiKeyValue): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.CreateConnectionApiKeyAuthRequestParameters.ReadOnly =
    zio.aws.eventbridge.model.CreateConnectionApiKeyAuthRequestParameters
      .wrap(buildAwsValue())
}
object CreateConnectionApiKeyAuthRequestParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.CreateConnectionApiKeyAuthRequestParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.eventbridge.model.CreateConnectionApiKeyAuthRequestParameters =
      zio.aws.eventbridge.model
        .CreateConnectionApiKeyAuthRequestParameters(apiKeyName, apiKeyValue)
    def apiKeyName: AuthHeaderParameters
    def apiKeyValue: AuthHeaderParametersSensitive
    def getApiKeyName: ZIO[Any, Nothing, AuthHeaderParameters] =
      ZIO.succeed(apiKeyName)
    def getApiKeyValue: ZIO[Any, Nothing, AuthHeaderParametersSensitive] =
      ZIO.succeed(apiKeyValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateConnectionApiKeyAuthRequestParameters
  ) extends zio.aws.eventbridge.model.CreateConnectionApiKeyAuthRequestParameters.ReadOnly {
    override val apiKeyName: AuthHeaderParameters =
      zio.aws.eventbridge.model.primitives
        .AuthHeaderParameters(impl.apiKeyName())
    override val apiKeyValue: AuthHeaderParametersSensitive =
      zio.aws.eventbridge.model.primitives
        .AuthHeaderParametersSensitive(impl.apiKeyValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateConnectionApiKeyAuthRequestParameters
  ): zio.aws.eventbridge.model.CreateConnectionApiKeyAuthRequestParameters.ReadOnly =
    new Wrapper(impl)
}
