package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.{
  AuthHeaderParametersSensitive,
  AuthHeaderParameters
}
import scala.jdk.CollectionConverters.*
final case class CreateConnectionOAuthClientRequestParameters(
    clientID: AuthHeaderParameters,
    clientSecret: AuthHeaderParametersSensitive
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.CreateConnectionOAuthClientRequestParameters = {
    import CreateConnectionOAuthClientRequestParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.CreateConnectionOAuthClientRequestParameters
      .builder()
      .clientID(AuthHeaderParameters.unwrap(clientID): java.lang.String)
      .clientSecret(
        AuthHeaderParametersSensitive.unwrap(clientSecret): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.CreateConnectionOAuthClientRequestParameters.ReadOnly =
    zio.aws.eventbridge.model.CreateConnectionOAuthClientRequestParameters
      .wrap(buildAwsValue())
}
object CreateConnectionOAuthClientRequestParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.CreateConnectionOAuthClientRequestParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.eventbridge.model.CreateConnectionOAuthClientRequestParameters =
      zio.aws.eventbridge.model
        .CreateConnectionOAuthClientRequestParameters(clientID, clientSecret)
    def clientID: AuthHeaderParameters
    def clientSecret: AuthHeaderParametersSensitive
    def getClientID: ZIO[Any, Nothing, AuthHeaderParameters] =
      ZIO.succeed(clientID)
    def getClientSecret: ZIO[Any, Nothing, AuthHeaderParametersSensitive] =
      ZIO.succeed(clientSecret)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateConnectionOAuthClientRequestParameters
  ) extends zio.aws.eventbridge.model.CreateConnectionOAuthClientRequestParameters.ReadOnly {
    override val clientID: AuthHeaderParameters =
      zio.aws.eventbridge.model.primitives.AuthHeaderParameters(impl.clientID())
    override val clientSecret: AuthHeaderParametersSensitive =
      zio.aws.eventbridge.model.primitives
        .AuthHeaderParametersSensitive(impl.clientSecret())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateConnectionOAuthClientRequestParameters
  ): zio.aws.eventbridge.model.CreateConnectionOAuthClientRequestParameters.ReadOnly =
    new Wrapper(impl)
}
