package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.HttpsEndpoint
import scala.jdk.CollectionConverters.*
final case class CreateConnectionOAuthRequestParameters(
    clientParameters: zio.aws.eventbridge.model.CreateConnectionOAuthClientRequestParameters,
    authorizationEndpoint: HttpsEndpoint,
    httpMethod: zio.aws.eventbridge.model.ConnectionOAuthHttpMethod,
    oAuthHttpParameters: Optional[
      zio.aws.eventbridge.model.ConnectionHttpParameters
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.CreateConnectionOAuthRequestParameters = {
    import CreateConnectionOAuthRequestParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.CreateConnectionOAuthRequestParameters
      .builder()
      .clientParameters(clientParameters.buildAwsValue())
      .authorizationEndpoint(
        HttpsEndpoint.unwrap(authorizationEndpoint): java.lang.String
      )
      .httpMethod(httpMethod.unwrap)
      .optionallyWith(oAuthHttpParameters.map(value => value.buildAwsValue()))(
        _.oAuthHttpParameters
      )
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.CreateConnectionOAuthRequestParameters.ReadOnly =
    zio.aws.eventbridge.model.CreateConnectionOAuthRequestParameters
      .wrap(buildAwsValue())
}
object CreateConnectionOAuthRequestParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.CreateConnectionOAuthRequestParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.eventbridge.model.CreateConnectionOAuthRequestParameters =
      zio.aws.eventbridge.model.CreateConnectionOAuthRequestParameters(
        clientParameters.asEditable,
        authorizationEndpoint,
        httpMethod,
        oAuthHttpParameters.map(value => value.asEditable)
      )
    def clientParameters
        : zio.aws.eventbridge.model.CreateConnectionOAuthClientRequestParameters.ReadOnly
    def authorizationEndpoint: HttpsEndpoint
    def httpMethod: zio.aws.eventbridge.model.ConnectionOAuthHttpMethod
    def oAuthHttpParameters
        : Optional[zio.aws.eventbridge.model.ConnectionHttpParameters.ReadOnly]
    def getClientParameters: ZIO[
      Any,
      Nothing,
      zio.aws.eventbridge.model.CreateConnectionOAuthClientRequestParameters.ReadOnly
    ] = ZIO.succeed(clientParameters)
    def getAuthorizationEndpoint: ZIO[Any, Nothing, HttpsEndpoint] =
      ZIO.succeed(authorizationEndpoint)
    def getHttpMethod: ZIO[
      Any,
      Nothing,
      zio.aws.eventbridge.model.ConnectionOAuthHttpMethod
    ] = ZIO.succeed(httpMethod)
    def getOAuthHttpParameters: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.ConnectionHttpParameters.ReadOnly
    ] = AwsError.unwrapOptionField("oAuthHttpParameters", oAuthHttpParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateConnectionOAuthRequestParameters
  ) extends zio.aws.eventbridge.model.CreateConnectionOAuthRequestParameters.ReadOnly {
    override val clientParameters
        : zio.aws.eventbridge.model.CreateConnectionOAuthClientRequestParameters.ReadOnly =
      zio.aws.eventbridge.model.CreateConnectionOAuthClientRequestParameters
        .wrap(impl.clientParameters())
    override val authorizationEndpoint: HttpsEndpoint =
      zio.aws.eventbridge.model.primitives
        .HttpsEndpoint(impl.authorizationEndpoint())
    override val httpMethod
        : zio.aws.eventbridge.model.ConnectionOAuthHttpMethod =
      zio.aws.eventbridge.model.ConnectionOAuthHttpMethod
        .wrap(impl.httpMethod())
    override val oAuthHttpParameters: Optional[
      zio.aws.eventbridge.model.ConnectionHttpParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.oAuthHttpParameters())
      .map(value =>
        zio.aws.eventbridge.model.ConnectionHttpParameters.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateConnectionOAuthRequestParameters
  ): zio.aws.eventbridge.model.CreateConnectionOAuthRequestParameters.ReadOnly =
    new Wrapper(impl)
}
